// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/quota/ABEGO_SS_Map.hh
/// @brief class for a quota pool based on secondary structure prediction and ABEGO torsion bin classification
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_quota_ABEGO_SS_Map_HH
#define INCLUDED_core_fragment_picking_quota_ABEGO_SS_Map_HH

#include <core/fragment/picking/quota/ABEGO_SS_Map.fwd.hh>
#include <core/fragment/picking/quota/QuotaPool.hh>

// package headers
#include <core/fragment/picking/BoundedCollector.hh>
#include <core/fragment/picking/FragmentCandidate.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>
#include <core/fragment/picking/CommonFragmentComparators.hh>
#include <core/conformation/SecondaryStructure.hh>

// utility headers
#include <core/types.hh>
#include <utility/vector1.hh>
#include <utility/pointer/owning_ptr.hh>

// C++ headers
#include <string>
#include <utility>

namespace core {
namespace fragment {
namespace picking {
namespace quota {


Size torsion2big_bin_id(core::Real const phi,  core::Real const psi,  core::Real const omega);
Size abego_index(char);
Size ss_index(char);

/// @brief represents a single pool used by quota selector
class ABEGO_SS_Map : public utility::pointer::ReferenceCount {
public:

	ABEGO_SS_Map(utility::vector1< std::pair<Size,Size> >);

	inline bool check_status(char ss_type,char abego_type) const {

	    return ss_abego_types_[ss_index(ss_type)][abego_index(abego_type)];
	}

	inline bool check_status(char ss_type,Size abego_type) const {

	    return ss_abego_types_[ss_index(ss_type)][abego_type];
	}

	inline bool check_status(Size ss_type,char abego_type) const {

	    return ss_abego_types_[ss_type][abego_index(abego_type)];
	}

	inline bool check_status(std::pair<Size,Size> bin_index) const {
	    return ss_abego_types_[bin_index.first][bin_index.second];
	}

	inline void set_status(std::pair<Size,Size> bin_index,bool new_status) {
    	    ss_abego_types_[bin_index.first][bin_index.second] = new_status;
	}

	std::string show_valid();

	char abego_char(Size abego_bin) { return all_abego_[abego_bin]; }

private:
	static char all_abego_[];
	static char all_ss_[];
	utility::vector1<utility::vector1<bool> > ss_abego_types_;
};

} // quota
} // picking
} // fragment
} // core


#endif /* INCLUDED_core_fragment_picking_quota_ABEGO_SS_Map_HH */
