// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/DihedralConstraintsScore.hh
/// @brief
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_DihedralConstraintsScore_HH
#define INCLUDED_core_fragment_picking_DihedralConstraintsScore_HH

#include <core/fragment/picking/scores/DihedralConstraintsScore.fwd.hh>
#ifdef  WIN32
#include <core/fragment/picking/scores/FourAtomsConstraintData.hh>
#endif

#include <core/fragment/picking/scores/AtomBasedConstraintsScore.hh>

// package headers
#include <core/fragment/picking/scores/FragmentScoringMethod.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>
#include <core/fragment/picking/FragmentPicker.fwd.hh>
// mini
#include <core/scoring/constraints/FuncFactory.hh>
#include <numeric/xyzVector.hh>

//Auto Headers
#include <core/fragment/picking/scores/FourAtomsConstraintData.fwd.hh>


namespace core {
namespace fragment {
namespace picking {
namespace scores {

/// @brief Scores a fragment with a set of Dihedral constraints
class DihedralConstraintsScore: public AtomBasedConstraintsScore {
public:

	/// @brief Prepare an atom-based score that utilizes some user-defined atoms
	/// @detailed User may provide names of atoms that will be cached when a new
	/// chunk is considered (i.e. at every do_caching() call)
	DihedralConstraintsScore(Size, Real, bool, std::string, Size, utility::vector1<
			std::string>);

	/// @brief Prepare an atom-based score that utilizes the following predefined atoms: N, CA, C, O and CB
	/// @detailed These atoms that will be cached when a new
	/// chunk is considered (i.e. at every do_caching() call)
	DihedralConstraintsScore(Size, Real, bool, std::string, Size);

	/// @brief Calculates the score
	bool cached_score(FragmentCandidateOP, FragmentScoreMapOP);

private:
	utility::vector1<utility::vector1<FourAtomsConstraintDataOP> > data_;
	void read_constraints(std::string);
	Size get_atom_type(std::string atom_name);
	core::scoring::constraints::FuncFactory factory_;
};


/// @brief  Maker class that produces a new DihedralConstraintsScore object
class MakeDihedralConstraintsScore: public MakeFragmentScoringMethod {
public:

	MakeDihedralConstraintsScore() :
		MakeFragmentScoringMethod("DihedralConstraintsScore") {
	}

	FragmentScoringMethodOP make(Size, Real, bool, FragmentPickerOP, std::string);
};
} // scores
} // picking
} // fragment
} // core

#endif /* INCLUDED_core_fragment_picking_AtomPairConstraintsScore_HH */

