// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/MidPhiOut.hh
/// @brief  Scores fragments by disulfide-linke Calpha distances
/// @author Robert Vernon

#ifndef INCLUDED_core_fragment_picking_DisulfideDistance_HH
#define INCLUDED_core_fragment_picking_DisulfideDistance_HH

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/PhiPsiTalosIO.hh>

#include <core/fragment/picking/scores/CachingScoringMethod.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

// mini
#include <core/types.hh>

#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

//Auto Headers
#include <core/pose/Pose.fwd.hh>
#include <iostream>


namespace core {
namespace fragment {
namespace picking {
namespace scores {

/// @brief  scores a fragment by the root mean square deviation of Phi and Psi angles.
class DisulfideDistance: public CachingScoringMethod {
public:

	/// @brief  creates a Calpha distance based scoring function.
	/// @detailed Scores distance matches for short range disulfides (ie: within fragment)
	DisulfideDistance(Size priority, Real lowest_acceptable_value, bool use_lowest,
										utility::vector1< Size > disulfide_data, Size largest_fragment);

	void do_caching(VallChunkOP);
	void clean_up();
	bool score(FragmentCandidateOP, FragmentScoreMapOP);
	bool cached_score(FragmentCandidateOP, FragmentScoreMapOP);

private:
	Size n_res_;
	std::string cached_scores_id_;

	ObjexxFCL::FArray2D_double chunk_ca_distances_;

	utility::vector1< Size > disulfide_data_;
	Size largest_fragment_;
};

/// @brief  Matker class that produces a new DisulfideDistance object
class MakeDisulfideDistance: public MakeFragmentScoringMethod {
public:

	MakeDisulfideDistance() :
		MakeFragmentScoringMethod("DisulfideDistance") {
	}

	FragmentScoringMethodOP make(Size, Real, bool, FragmentPickerOP, std::string);
};

}
}
}
}

#endif // INCLUDED_core_fragment_picking_DisulfideDistance_HH
