// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/MidPsiOut.hh
/// @brief  Object that scores a fragment by its crmsd to the native
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_MidPsiOut_HH
#define INCLUDED_core_fragment_picking_MidPsiOut_HH

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>

#include <core/fragment/picking/scores/CachingScoringMethod.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

// mini
#include <core/types.hh>

#include <ObjexxFCL/FArray1D.hh>

//Auto Headers
#include <core/pose/Pose.fwd.hh>
#include <iostream>


namespace core {
namespace fragment {
namespace picking {
namespace scores {

typedef utility::vector1<utility::vector1<Real> > Matrix;

/// @brief  scores a fragment by the root mean square deviation of Psi and Psi angles.
class MidPsiOut: public CachingScoringMethod {
public:

	/// @brief  creates a Psi-Psi-based scoring function.
	/// @detailed Psi-Psi angles from a fragment will be compared to relevant angles in a given pose, which should have the same number of residues a the query sequence
	MidPsiOut(Size priority, Real lowest_acceptable_value, bool use_lowest);

	void do_caching(VallChunkOP);
	void clean_up();
	bool score(FragmentCandidateOP, FragmentScoreMapOP);
	bool cached_score(FragmentCandidateOP, FragmentScoreMapOP);

private:
	ObjexxFCL::FArray1D_double chunk_psi_;

	std::string cached_scores_id_;
};

/// @brief  Matker class that produces a new MidPsiOut object
class MakeMidPsiOut: public MakeFragmentScoringMethod {
public:

	MakeMidPsiOut() :
		MakeFragmentScoringMethod("MidPsiOut") {
	}

	FragmentScoringMethodOP make(Size, Real, bool, FragmentPickerOP, std::string);
};

}
}
}
}

#endif // INCLUDED_core_fragment_picking_MidPsiOut_HH
