// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/fragment/picking/scores/ScoreEValuator.hh
/// @brief  Object that scores a fragment by its crmsd to the native
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_fragment_picking_ScoreEValuator_HH
#define INCLUDED_core_fragment_picking_ScoreEValuator_HH

// package headers
#include <core/fragment/picking/FragmentCandidate.fwd.hh>
#include <core/fragment/picking/scores/ProfileScore.hh>
#include <core/fragment/picking/scores/FragmentScoreMap.fwd.hh>

#include <core/types.hh>

// AUTO-REMOVED #include <core/pose/util.hh>

namespace core {
namespace fragment {
namespace picking {
namespace scores {

typedef utility::vector1<utility::vector1<Real> > Matrix;

/// @brief  Computes E-Value for a Profile object
class ScoreEValuator: public ProfileScore {

public:
	ScoreEValuator(Size priority, Real lowest_acceptable_value,
			bool use_lowest, sequence::SequenceProfileOP query_profile,
			sequence::ScoringSchemeOP profile_scoring, Size largest_chunk_size) :
		ProfileScore(priority, lowest_acceptable_value, use_lowest, query_profile,
				profile_scoring, largest_chunk_size) {
		max_rand_ = 12;
	}

	void do_caching(VallChunkOP);
	void clean_up();
	bool score(FragmentCandidateOP, FragmentScoreMapOP);
	bool describe_score(FragmentCandidateOP f, FragmentScoreMapOP empty_map,
			std::ostream& out);
private:
	Size max_rand_;
};

class MakeScoreEValuator: public MakeFragmentScoringMethod {
public:

	MakeScoreEValuator() :
		MakeFragmentScoringMethod("ScoreEValuator") {
	}

	FragmentScoringMethodOP make(Size, Real, bool, FragmentPickerOP);
};

}
}
}
}

#endif /* INCLUDED_core_fragment_picking_ScoreEValuator_HH */
