// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/graph/PointGraph.cc
/// @brief  Graph for detecting neighbors; vertices store points, edges store square distances
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

// Unit Headers
#include <core/graph/PointGraph.hh>

// Project Headers
#include <core/pose/Pose.hh>
#include <core/chemical/ResidueType.hh>
#include <core/conformation/Residue.hh>

//Auto Headers
#include <core/graph/PointGraphData.hh>
#include <core/graph/UpperEdgeGraph.hh>


namespace core {
namespace graph {

void
residue_point_graph_from_pose(
	pose::Pose const & pose,
	graph::PointGraph & pg
)
{
	pg.set_num_vertices( pose.total_residue() );
	for ( platform::Size ii = 1, ii_end = pose.total_residue(); ii <= ii_end; ++ii ) {
		pg.get_vertex( ii ).data().xyz() = pose.residue(ii).xyz( pose.residue( ii ).nbr_atom() );
	}
}

	///@brief returns a Distance
platform::Real
pose_max_nbr_radius( pose::Pose const & pose )
{
	platform::Real maxrad( 0.0 );
	for ( platform::Size ii = 1; ii <= pose.total_residue(); ++ii ) {
		if ( pose.residue( ii ).nbr_radius() > maxrad ) maxrad = pose.residue_type(ii).nbr_radius();
	}
	return maxrad;
}

} // namespace graph
} // namespace core
