// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/graph/PointGraph.fwd.hh
/// @brief  Graph for detecting neighbors; vertices store points, edges store square distances
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

#ifndef INCLUDED_core_graph_PointGraph_FWD_HH
#define INCLUDED_core_graph_PointGraph_FWD_HH

// Package Headers
#include <core/graph/PointGraphData.fwd.hh>
#include <core/graph/UpperEdgeGraph.fwd.hh>

// Utility Headers
#include <utility/pointer/owning_ptr.hh>

namespace core {
namespace graph {

typedef UpperEdgeGraph< PointGraphVertexData, PointGraphEdgeData > PointGraph;

typedef utility::pointer::owning_ptr< PointGraph > PointGraphOP;

}
}

#endif
