// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/grid/Pockets/FingerprintMultifunc.hh
/// @brief  Fingerprint comparison multifunction class
/// @author Ragul Gowthaman


#ifndef INCLUDED_core_grid_Pockets_FingerprintMultifunc_HH
#define INCLUDED_core_grid_Pockets_FingerprintMultifunc_HH

// Package headers
#include <core/optimization/types.hh>
#include <core/optimization/Multifunc.hh>
#include <core/grid/Pockets/Fingerprint.hh>

namespace core {
namespace grid {
namespace Pockets {

/// @brief Atom tree multifunction class
class FingerprintMultifunc : public core::optimization::Multifunc {

public: // Creation

	// c-tor
	FingerprintMultifunc(
		NonPlaidFingerprint const & nfp_in,
		PlaidFingerprint & pfp_in,
		core::Real const & rho_weight,
		core::Real const & steric_weight
	);

	/// @brief Destructor
	inline
	virtual
	~FingerprintMultifunc()
	{}

public: // Methods

	// func
	virtual
	Real
	operator ()( core::optimization::Multivec const & vars ) const;

	// dfunc
	virtual
	void
	dfunc( core::optimization::Multivec const & , core::optimization::Multivec & ) const;

	/// @brief Error state reached; dump out current pdb.
	virtual
	void
	dump( core::optimization::Multivec const & vars ) const;

private:

  NonPlaidFingerprint const & nfp_;
  PlaidFingerprint & pfp_;
	core::Real rho_;
	core::Real steric_;

}; // FingerprintMultifunc


} // namespace Pockets
} // namespace grid
} // namespace core


#endif // INCLUDED_core_grid_Pockets_FingerprintMultifunc_HH
