// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/grid/Pockets/QuaternionFingerprint.fwd.hh
/// @brief  core::grid::Pockets::QuaternionFingerprint forward declarations header
/// @author Ragul Gowthaman


#ifndef INCLUDED_core_grid_Pockets_QuaternionFingerprint_FWD_HH
#define INCLUDED_core_grid_Pockets_QuaternionFingerprint_FWD_HH


// Utility headers
#include <utility/pointer/owning_ptr.fwd.hh>


namespace core {
namespace grid {
namespace Pockets {

// Forward
class Quaternion;
class QuaternionFingerprintBase;
class NonPlaidQuaternionFingerprint;
class PlaidQuaternionFingerprint;

// Types
typedef utility::pointer::owning_ptr< NonPlaidQuaternionFingerprint >  NonPlaidQuaternionFingerprintOP;
typedef utility::pointer::owning_ptr< NonPlaidQuaternionFingerprint const >  NonPlaidQuaternionFingerprintCOP;
typedef utility::pointer::owning_ptr< PlaidQuaternionFingerprint >  PlaidQuaternionFingerprintOP;
typedef utility::pointer::owning_ptr< PlaidQuaternionFingerprint const >  PlaidQuaternionFingerprintCOP;


} // namespace Pockets
} // namespace grid
} // namespace core

#endif
