// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file core/io/silent/SilentStructFactory.hh
///
/// @brief factory for creating silent struct objects
/// @author James Thompson

#ifndef INCLUDED_core_io_silent_SilentStructFactory_HH
#define INCLUDED_core_io_silent_SilentStructFactory_HH

#include <core/pose/Pose.fwd.hh>

#include <core/io/silent/SilentStruct.fwd.hh>
#include <utility/pointer/ReferenceCount.hh>

// AUTO-REMOVED #include <string>

namespace core {
namespace io {
namespace silent {

class SilentStructFactory : public utility::pointer::ReferenceCount {

public:

	/// @brief constructor
	SilentStructFactory();

	static SilentStructOP get_silent_struct_in();
	static SilentStructOP get_silent_struct_out();
	static SilentStructOP get_silent_struct_out( core::pose::Pose const& pose );
	static SilentStructOP get_silent_struct( std::string const & name );

}; // class SilentStructFactory


} // namespace silent
} // namespace io
} // namespace core

#endif
