// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pose/datacache/CacheableDataType.hh
/// @brief  enum indexing the data types stored in a Pose's internal DataCache
/// @author

#ifndef INCLUDED_core_pose_datacache_CacheableDataType_HH
#define INCLUDED_core_pose_datacache_CacheableDataType_HH


namespace core {
namespace pose {
namespace datacache {


// hold the enum within a descriptive namespace to avoid name collisions
namespace CacheableDataType {

/// @brief enum indexing the data types stored in a Pose's internal DataCache
enum Enum {
	BASE_PARTNER = 1, // for indexing into vector1
	CEN_LIST_INFO,
	MEMBRANE_TOPOLOGY,
	MEMBRANE_EMBED,
	MEMBRANE_POTENTIAL, //pba
	INTERFACE_INFO,
	RB_JUMP,
	SS_INFO,
	SS_KILLHAIRPINS_INFO,
	RNA_SCORING_INFO,
	RNA_SECSTRUCT_INFO,
	JOBDIST_OUTPUT_TAG, //< a CacheableStringOP
	WATER_PACKING_INFO,
	SCORE_MAP, //<DiagnosticDataOP
	FILTER_STAGE2_BEGINNING,
	FILTER_STAGE2_QUARTER,
	FILTER_STAGE2_HALF,
	FILTER_STAGE2_END,
	ARBITRARY_FLOAT_DATA,
	POSE_BEFORE_CAVITIES_ADDED,
	STRING_MAP, // string-based annotations about a Pose
	SCORE_LINE_STRINGS, // score entries composed of a pair< string, string >
//	PDB_INFO,
	HOLES_POSE_INFO,
	SEQUENCE_PROFILE,
	DAB_SASA_POSE_INFO,
	DAB_SEV_POSE_INFO,
	RESIDUAL_DIPOLAR_COUPLING_DATA,//NMR Residual Dipolar Coupling data
	RESIDUAL_DIPOLAR_COUPLING_DATA_ROHL,//NMR Residual Dipolar Coupling data - for rdc_rohl
	RESIDUAL_DIPOLAR_COUPLING_SEGMENTS_DATA,
	PSEUDOCONTACT_SHIFT_DATA,//NMR Psuedocontact Shift (PCS) data SHOULD DESEAPPEAR END 2010
	PSEUDOCONTACT_SHIFT_MULTI_DATA,//NMR Psuedocontact Shift (PCS) data, multi paramgnetic center
	CUSTOM_PAIR_DIST_SCORE_INFO,
	GEN_BORN_POSE_INFO,
	MEMBRANE_FAEMBED, //pba high reslution membrane embedding info
	// *** IMPORTANT ***
	// The 'num_cacheable_data_types' below must be the last enum, and must
	// always be set equal to the (last-1) enum.  If you append a new enum
	// to the list, remember to change the value below!
//	num_cacheable_data_types = GEN_BORN_POSE_INFO
  num_cacheable_data_types = MEMBRANE_FAEMBED
};

} // namespace CacheableDataType


} // namespace datacache
} // namespace pose
} // namespace core


#endif /* INCLUDED_core_pose_datacache_CacheableDataType_HH */
