// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/MinimizationData.hh
/// @brief  A container class for use by certain EnergyMethods during derivative and
//          score function evaluation during minimization routines.
/// @author Andrew Leaver-Fay

#ifndef INCLUDED_core_scoring_MinimizationData_HH
#define INCLUDED_core_scoring_MinimizationData_HH

// Unit headers
#include <core/scoring/MinimizationData.fwd.hh>

// Project headers
#include <core/util/datacache/CacheableData.fwd.hh>
#ifdef WIN32
#include <core/util/datacache/CacheableData.hh>
#endif

// Utility headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>

namespace core {
namespace scoring {

enum min_single_data{
	etab_single_nblist = 1,
	cst_res_data,
	hbond_res_data,
	n_min_single_data = hbond_res_data // keep this guy last
};

enum min_pair_data {
	etab_pair_nblist = 1,
	cst_respair_data,
	hackelec_pair_nblist,
	fa_dslf_respair_data,
	fa_custom_pair_dist_data,
	hbond_respair_data,
	n_min_pair_data = hbond_respair_data // keep this guy last
};


class ResSingleMinimizationData : public utility::pointer::ReferenceCount
{
public:
	typedef util::datacache::CacheableData    CacheableData;
	typedef util::datacache::CacheableDataOP  CacheableDataOP;
	typedef util::datacache::CacheableDataCOP CacheableDataCOP;

public:
	ResSingleMinimizationData();
	virtual ~ResSingleMinimizationData();
	ResSingleMinimizationData( ResSingleMinimizationData const & ); // deep copy
	ResSingleMinimizationData const & operator = ( ResSingleMinimizationData const & ); // deep copy

	void set_data( min_single_data index, CacheableDataOP data );
	CacheableDataOP get_data( min_single_data index );
	CacheableDataCOP get_data( min_single_data index ) const;
	CacheableData & get_data_ref( min_single_data index ) { return * data_cache_[ index ]; }
	CacheableData const & get_data_ref( min_single_data index ) const { return * data_cache_[ index ]; }

private:

private:
	utility::vector1< CacheableDataOP > data_cache_;

};

class ResPairMinimizationData : public utility::pointer::ReferenceCount
{
public:
	typedef util::datacache::CacheableData    CacheableData;
	typedef util::datacache::CacheableDataOP  CacheableDataOP;
	typedef util::datacache::CacheableDataCOP CacheableDataCOP;

public:
	ResPairMinimizationData();
	virtual ~ResPairMinimizationData();
	ResPairMinimizationData( ResPairMinimizationData const & ); // deep copy
	ResPairMinimizationData const & operator = ( ResPairMinimizationData const & ); // deep copy

	void set_data( min_pair_data index, CacheableDataOP );
	CacheableDataOP get_data( min_pair_data index );
	CacheableDataCOP get_data( min_pair_data index ) const;
	CacheableData & get_data_ref( min_pair_data index ) { return * data_cache_[ index ]; }
	CacheableData const & get_data_ref( min_pair_data index ) const { return * data_cache_[ index ]; }


private:
	utility::vector1< CacheableDataOP > data_cache_;
};

}
}

#endif
