// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   core/scoring/constraints/PocketConstraint.hh
///
/// @brief
/// @author David Johnson


#ifndef INCLUDED_core_scoring_constraints_PocketConstraint_HH
#define INCLUDED_core_scoring_constraints_PocketConstraint_HH

#include <core/scoring/constraints/Constraint.hh>
#include <core/grid/Pockets/PocketGrid.hh>
#include <math.h>
#include <core/id/AtomID.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/vector1.hh>
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/ReferenceCount.hh>
#include <list>

namespace core {
namespace scoring {
namespace constraints {

///@brief This constraint favors creating a pocket suitable for a small-molecule
///
class PocketConstraint : public Constraint
{
public:
  virtual std::string type() const {
    return "Pocket";
  }

  PocketConstraint( pose::Pose const & pose );
  PocketConstraint( const PocketConstraint& old );

  Size target_res() const { return seqpos_; }
  virtual ~PocketConstraint();

  virtual Size natoms() const { return atom_ids_.size(); };

  virtual AtomID const & atom( Size const index ) const { return atom_ids_[index]; };

  virtual
  void score( XYZ_Func const & xyz_func, EnergyMap const & weights, EnergyMap & emap ) const;

  virtual
  void
  fill_f1_f2(
    AtomID const & ,
    XYZ_Func const & ,
    Vector & ,
    Vector & ,
    EnergyMap const & weights
  ) const;

  virtual
  ConstraintOP clone() const;

  void set_target_res( pose::Pose const & pose, Size new_seqpos );
  void set_target_res_pdb( pose::Pose const & pose, std::string resid );

private:

  Size seqpos_;
  Size totalres_;
  mutable core::grid::Pockets::PocketGridOP pocketgrid_;
  utility::vector1< AtomID > atom_ids_;
  bool dumppdb_;

}; // PocketConstraint

typedef utility::pointer::owning_ptr< PocketConstraint > PocketConstraintOP;

} // namespace constraints
} // namespace scoring
} // namespace core

#endif // INCLUDED_core_scoring_constraints_PocketConstraint_HH
