// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/types.hh
/// @brief  core::scoring package type declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_core_scoring_hbonds_constants_HH
#define INCLUDED_core_scoring_hbonds_constants_HH


// Project Headers
#include <core/scoring/hbonds/types.hh>
#include <core/types.hh>

// Numeric Headers
#include <numeric/constants.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray2D.fwd.hh>



namespace core {
namespace scoring {
namespace hbonds {


// This gives the size of the evaluation related lookup tables defined
// in the HBondDatabase
Size const HB_EVAL_TYPE_COUNT = { (hbdon_MAX-1)*(hbacc_MAX-1)*(seq_sep_MAX-1)};

Size const SHORT_RANGE_CUTOFF = { 4 };
Size const GENERIC_SHORTRANGE_SEQ_CUTOFF = { 1 };

//car cutoffs defining what is a hbond
static core::Real const MAX_R = { 3.0 };
static core::Real const MIN_R = { 1.4 }; // AH distance
	//static core::Real const MIN_xH = { -0.5 }; // cos( radians( 180.0 - 90.0 ) )  // psi cutoff
static core::Real const MIN_xH = { 0.0 }; // cos( radians( 180.0 - 90.0 ) )  // psi cutoff
static core::Real const MIN_xD = { 0.0 }; // cos( radians( 180.0 - 90.0 ) )  // theta cutoff
static core::Real const MIN_xC = { 0.0 }; // chi cutoff
static core::Real const MAX_xH = { 1.0 }; // cos( radians( 180.0 - 180.0 ) )  // psi cutoff
static core::Real const MAX_xD = { 1.0 }; // cos( radians( 180.0 - 180.0 ) )  // theta cutoff
static core::Real const MAX_xC = { numeric::constants::d::pi_2 }; // chi cutoff
static core::Real const R_INTERP_EDGE = { 2.1 };
static core::Real const ANGLE_INTERP_EDGE = { .05 };

core::Real LR_MIN_R_CUT();
core::Real LR_MAX_R_CUT();
core::Real LR_MIN_R_FADE();
core::Real LR_MAX_R_FADE();
core::Real MIN_xD_CUT();
core::Real MIN_xD_FADE();
core::Real MIN_xH_CUT();
core::Real MIN_xH_FADE();

static core::Real const MIN_R2 = { MIN_R * MIN_R };
static core::Real const MAX_R2 = { MAX_R * MAX_R };

static core::Real const MAX_HB_ENERGY = { 0.0 }; // at and above this cutoff, not considered a hbond

//car for sidechain hbonds, separate polynomials exist for short and long
//car distances  // JSS This makes their computation rather baroque...
//JSS Need these to be static core::Reals so I can initialize classes with them
static core::Real const SWITCH_DIS = { 2.1 }; // distance cutoff for sidechain hbonds tables
static core::Real const INTERP_RANGE = { 0.2 };
// interpolate if AH dist falls between switch +/- range
static core::Real const INTERP_MIN = { SWITCH_DIS - INTERP_RANGE };
static core::Real const INTERP_MAX = { SWITCH_DIS + INTERP_RANGE };



} // namespace hbonds
} // namespace scoring
} // namespace core


#endif // INCLUDED_core_scoring_types_HH
