// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author

#ifndef INCLUDED_core_scoring_hbonds_hbonds_geom_HH
#define INCLUDED_core_scoring_hbonds_hbonds_geom_HH

// Package headers
#include <core/scoring/hbonds/types.hh>
#include <core/scoring/hbonds/HBondSet.fwd.hh>
#include <core/scoring/hbonds/hbtrie/HBAtom.hh>
#include <core/scoring/hbonds/HBondDatabase.fwd.hh>
#include <core/scoring/DerivVectorPair.fwd.hh>

// Project headers
#include <core/chemical/types.hh>
#include <core/conformation/Residue.fwd.hh>



namespace core {
namespace scoring {
namespace hbonds {

HBAccChemType
get_hb_acc_chem_type(
	int const aatm,
	conformation::Residue const & acc_rsd
);

HBDonChemType
get_hb_don_chem_type(
	int const datm,
	conformation::Residue const & don_rsd
);

HBEvalType
hbond_evaluation_type(
	hbtrie::HBAtom const & datm,
	int const & don_rsd,
	hbtrie::HBAtom const & aatm,
	int const & acc_rsd
);

HBSeqSep
get_seq_sep(
	HBDonChemType const & don_chem_type,
	HBAccChemType const & acc_chem_type,
	int const & sep
);

// hbond evaluation type -- determines what scoring function to use
extern Real DUMMY_DERIV;
extern HBondDerivs DUMMY_DERIVS;
extern HBondDerivs const ZERO_DERIV2D;


HBEvalType
hbond_evaluation_type(
	int const datm,
	conformation::Residue const & don_rsd,
	int const aatm,
	conformation::Residue const & acc_rsd
);


void
hbond_compute_energy(
	HBondDatabaseCOP database,
	HBEvalType hbe, // used internally & by geometric solvation
	Real const AHdis, // acceptor proton distance
	Real const xD, // -cos(180-theta), where theta is defined by Tanja K.
	Real const xH, // cos(180-phi), where phi is defined by Tanja K.
	Real & energy,
	Real & dE_dr = DUMMY_DERIV,
	Real & dE_dxD = DUMMY_DERIV,
	Real & dE_dxH = DUMMY_DERIV
);

/// @brief Evaluate the hydrogen bond energy and derivatives after having first calculated
/// the HD and BA *u*nit vectors
void
hb_energy_deriv_u(
	HBondDatabaseCOP database,
	HBEvalType const hbe_type, // hbond evaluation type
	Vector const & Hxyz, // proton
	Vector const & Dxyz, // donor -- only needed for derivative evaluation
	Vector const & HDunit, // proton-to-donor unit vector
	Vector const & Axyz, // acceptor
	Vector const & Bxyz, // pseudo acceptor-base coordinate -- only needed for derivative evaluation
	Vector const & BAunit, // unit vector towards the acceptor base
	Real & energy,
	bool const calculate_derivative = false,
	HBondDerivs & deriv = DUMMY_DERIVS
);

/// @brief Evaluate the hydrogen bond energy and derivatives after having first calculated
/// the HD and BA *u*nit vectors; deriv type must have been chosen (why does this exist?)
void
hb_energy_deriv_u2(
	HBondDatabaseCOP database,
	HBEvalType const hbe_type, // hbond evaluation type
	HBDerivType const deriv_type,
	Vector const & Hxyz, // proton
	Vector const & Dxyz, // donor -- only needed for derivative evaluation
	Vector const & HDunit, // donor
	Vector const & Axyz, // acceptor
	Vector const & Bxyz, // pseudo acceptor-base coordinate -- only needed for derivative evaluation
	Vector const & BAunit, // unit vector towards base
	Real & energy,
	HBondDerivs & deriv = DUMMY_DERIVS
);


//hbond evaluation type -- determines what scoring function to use
void
hb_energy_deriv(
	HBondDatabaseCOP database,
	HBEvalType const hbe_type, // hbond evaluation type
	Vector const & Dxyz, // donor coords
	Vector const & Hxyz, // proton
	Vector const & Axyz, // acceptor
	Vector const & Bxyz, // acceptor base
	Vector const & B2xyz, // 2nd acceptor base for ring & SP3 acceptors
	Real & energy,
	bool const calculate_derivative = false,
	HBondDerivs & deriv = DUMMY_DERIVS // f1/f2 for four atoms
);

void
hb_energy_deriv(
	HBondDatabaseCOP database,
	HBEvalType const hbe_type, // hbond evaluation type
	Vector const & Dxyz, // donor coords
	Vector const & Hxyz, // proton
	Vector const & Axyz, // acceptor
	Vector const & Bxyz, // acceptor base
	Vector const & B2xyz, // 2nd acceptor base for ring & SP3 acceptors
	Real & energy,
	HBDerivType const deriv_type,
	HBondDerivs & deriv = DUMMY_DERIVS // f1/f2 for four atoms
);

Vector
create_acc_orientation_vector(
	conformation::Residue const & residue,
	int atom_id
);

// hack?
extern Real DUMMY_DERIV;


Vector
create_don_orientation_vector(
	conformation::Residue const & residue,
	int atom_id
);

void
make_hbBasetoAcc_unitvector(
	chemical::Hybridization const & acc_hybrid,
	Vector const & Axyz,
	Vector const & Bxyz,
	Vector const & B2xyz,
	Vector & PBxyz, /// the coordinate for the pseudo-acceptor-base atom, used in derivative evaluation
	Vector & BAunit
);

void
assign_abase_derivs(
	conformation::Residue const & acc_rsd,
	Size acc_atom,
	HBEvalType const hbe_type,
	DerivVectorPair const & abase_deriv,
	Real weighted_energy,
	utility::vector1< DerivVectorPair > & acc_atom_derivs
);


}
}
}

#endif
