// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

#ifndef ORBITALSLOOKUP_HH_
#define ORBITALSLOOKUP_HH_

#include <utility/vector1.hh>

#include <core/types.hh>

//project headers

#include <numeric/interpolation/spline/Bicubic_spline.hh>
#include <numeric/interpolation/spline/Interpolator.hh>
#include <map>

//STL header

#include <map>
#include <vector>

//Auto Headers
#include <iostream>


namespace core {
namespace scoring {
namespace orbitals {

class OrbitalsLookup {
public:
	enum h_type{hpol, haro, orb};
	OrbitalsLookup(const utility::vector1<std::string> & filename);

	core::Real get_energy
	(
			const h_type & h_enum,
			const std::string & mm_atom_name,
			const core::Real & distance,
			const core::Real & angle
	) const;

	Vector get_derivative
	(
			const h_type & h_enum,
			const std::string & mm_atom_name,
			const core::Real & distance,
			const core::Real & angle,
			Vector  & r_vec,
			Vector & z_i,
			Vector  & B_A_vector
	) const;

private:
	numeric::interpolation::spline::BicubicSpline * hpol_e1_spline_;
	numeric::interpolation::spline::BicubicSpline * hpol_e2_spline_;
	numeric::interpolation::spline::BicubicSpline * hpol_e3_spline_;
	numeric::interpolation::spline::BicubicSpline * hpol_e4_spline_;
	numeric::interpolation::spline::BicubicSpline * hpol_e5_spline_;
	numeric::interpolation::spline::BicubicSpline * hpol_e6_spline_;
	numeric::interpolation::spline::BicubicSpline * hpol_e7_spline_;

	numeric::interpolation::spline::BicubicSpline * haro_e1_spline_;
	numeric::interpolation::spline::BicubicSpline * haro_e2_spline_;
	numeric::interpolation::spline::BicubicSpline * haro_e3_spline_;
	numeric::interpolation::spline::BicubicSpline * haro_e4_spline_;
	numeric::interpolation::spline::BicubicSpline * haro_e5_spline_;
	numeric::interpolation::spline::BicubicSpline * haro_e6_spline_;
	numeric::interpolation::spline::BicubicSpline * haro_e7_spline_;

	numeric::interpolation::spline::BicubicSpline * orb_e1_spline_;
	numeric::interpolation::spline::BicubicSpline * orb_e2_spline_;
	numeric::interpolation::spline::BicubicSpline * orb_e3_spline_;
	numeric::interpolation::spline::BicubicSpline * orb_e4_spline_;
	numeric::interpolation::spline::BicubicSpline * orb_e5_spline_;
	numeric::interpolation::spline::BicubicSpline * orb_e6_spline_;
	numeric::interpolation::spline::BicubicSpline * orb_e7_spline_;

	std::map< std::string, numeric::interpolation::spline::BicubicSpline > hpol_splines_; //a map that contains all
	std::map< std::string, numeric::interpolation::spline::BicubicSpline > haro_splines_; //a map that contains all
	std::map< std::string, numeric::interpolation::spline::BicubicSpline > orb_splines_; //a map that contains all


};



}

}

}



#endif /* ORBITALSLOOKUP_HH_ */
