// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/saxs/FormFactorManager.hh
/// @brief Loads and manages atomic form factors
/// @author Dominik Gront (dgront@chem.uw.edu.pl)

#ifndef INCLUDED_core_scoring_saxs_FormFactorManager_HH
#define INCLUDED_core_scoring_saxs_FormFactorManager_HH

#include <core/scoring/saxs/FormFactorManager.fwd.hh>

#include <core/scoring/saxs/FormFactor.hh>

// utility headers
#include <core/types.hh>
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>

#include <map>
#include <set>
#include <string>

namespace core {
namespace scoring {
namespace saxs {

/// @brief selects a given number of fragments using a quota scheme
class FormFactorManager: public utility::pointer::ReferenceCount {
public:

	/// @brief return singleton of the manager
	static FormFactorManager* get_manager();

	void register_ff(std::string atom_name,FormFactorOP new_ff);

	void load_ff(std::string config_file);

	void load_ff_from_db(std::string file_name);

	/// @brief returns true if the manager has form factor function for a given atom
	bool is_known_atom(std::string atom_name);

	/// @brief returns form factor function for a given atom
	FormFactorOP get_ff(std::string atom_name);

	/// @brief returns a vector of know atom names
	utility::vector1<std::string> get_known_atoms() {

	    return known_atoms_;
	}

private:
	/// @brief all known FF are stored here
	std::map<std::string,FormFactorOP> ff_map_;
	/// @brief all known atom names
	utility::vector1<std::string> known_atoms_;
	static FormFactorManager* singleton_;

	/// @brief  Constructor reads basic form factors from library
	FormFactorManager() {}
};


} // core
} // scoring
} // saxs

#endif /* INCLUDED_core_scoring_saxs_FormFactorManager_HH */
