// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file CompositeSequence.cc
/// @author James Thompson

#include <core/types.hh>
#include <core/util/Tracer.hh>
#include <core/sequence/Sequence.hh>
#include <core/sequence/CompositeSequence.hh>

#include <utility/pointer/owning_ptr.hh>

#include <core/chemical/AA.hh>

#include <iostream>
#include <string>

namespace core {
namespace sequence {

static core::util::Tracer tr( "core.sequence.CompositeSequence" );

std::ostream & operator<<(
	std::ostream & out, const CompositeSequence & p
) {
	out << "CompositeSequence << method stubbed out!" << std::endl;
	return out;
}

} // sequence
} // core
