// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   src/core/util/ComparingTracer.hh
/// @brief  version of Tracer calss for to tracking down the source of an instability by compare
///         output with file.
/// @author Sergey Lyskov
///

#ifndef INCLUDED_core_util_ComparingTracer_HH
#define INCLUDED_core_util_ComparingTracer_HH

#include <core/util/Tracer.hh>

#include <fstream>


namespace core {
namespace util {

class ComparingTracer : public core::util::otstream
{
public:
	ComparingTracer(std::string const & file_name);
	virtual ~ComparingTracer();

protected:
	/// @brief overload member function.
	virtual void t_flush(std::string const & s);

private:
	//std::string  file_name_;
	std::fstream file_;

	/// @brief mode of operation:
	///                  if true: create model file, do not compare
	///                    false: read model file, and compare output against it, generating 'assert false'
	///                    if difference encountered.
	bool dry_run_;
};



} // namespace util
} // namespace core

#endif // INCLUDED_core_util_comparing_tracer_hh

