// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.



/// @file TracerToFile.hh
/// @brief Class for a tracer that writes all output to a file.
/// @author Matt O'Meara (mattjomeara@gmail.com)



#include <core/util/TracerToFile.hh>



namespace core {
namespace util {

TracerToFile::TracerToFile( std::string const & file_name )
{
  file_.open( file_name.c_str(), std::fstream::out );
}

TracerToFile::~TracerToFile()
{
  (*this) << std::endl;
  file_.close();
}


void TracerToFile::t_flush( std::string const & s )
{
  assert( file_.is_open() );
  file_ << s;
}

} // namespace util
} // namepsace corenested classes c+++
