// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/util/datacache/CacheableStringMap.hh
/// @brief
/// @author Phil Bradley


#ifndef INCLUDED_core_util_datacache_CacheableStringMap_HH
#define INCLUDED_core_util_datacache_CacheableStringMap_HH

// unit headers
#include <core/util/datacache/CacheableStringMap.fwd.hh>

// package headers
#include <core/util/datacache/CacheableData.hh>

// C++ headers
#include <map>
#include <string>


namespace core {
namespace util {
namespace datacache {


///@brief Wrapper for a map< string, string >.
class CacheableStringMap : public CacheableData
{
public:
	CacheableStringMap() : CacheableData() {}

	virtual ~CacheableStringMap() {}

	virtual CacheableDataOP clone() const {
		return new CacheableStringMap(*this);
	}

	virtual std::map< std::string, std::string > & map() {
		return map_;
	}

	virtual const std::map< std::string, std::string > & map() const {
		return map_;
	}

private:
	std::map< std::string, std::string > map_;
};


} // namespace datacache
} // namespace util
} // namespace core

#endif /* INCLUDED_core_util_datacache_CacheableStringMap_HH */
