// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file numeric/kdtree/KDTree.fwd.hh
/// @brief forward declaration for KDTree class.
/// @author James Thompson

#ifndef INCLUDED_numeric_kdtree_KDTree_FWD_HH
#define INCLUDED_numeric_kdtree_KDTree_FWD_HH

#include <utility/pointer/owning_ptr.hh>

namespace numeric {
namespace kdtree {

class KDTree;
typedef utility::pointer::owning_ptr< KDTree > KDTreeOP;
typedef utility::pointer::owning_ptr< KDTree const > KDTreeCOP;

} // kdtree
} // numeric

#endif
