// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file FragmentSampler.cc
/// @brief ab-initio fragment assembly protocol for proteins
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange

// Unit Headers
#include <protocols/NoesyAssign/PeakCalibrator.hh>

// Package Headers

// Project Headers

// Utility headers
#include <core/util/Tracer.hh>

//// C++ headers
#include <cmath>

static core::util::Tracer tr("devel.NoesyAssign.crosspeaks");

using core::Real;
using namespace core;
using namespace util;
//using namespace core::options;
//using namespace OptionKeys;

namespace protocols {
namespace NoesyAssign {

void PeakCalibrator::interpolate( PeakCalibrator const& cal1, PeakCalibrator const& cal2 ) {
  Q_backbone_ = exp( 0.5*( log( cal1.Q_backbone_) + log( cal2.Q_backbone_ ) ));
	Q_nonmethyl_beta_ = exp( 0.5*( log(cal1.Q_nonmethyl_beta_) + log( cal2.Q_nonmethyl_beta_) ));
  Q_methyl_ = 3.0 * Q_backbone_;
  Q_nonmethyl_sidechain_ = 1.5 * Q_nonmethyl_beta_;
}

}
}
