// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file PeakCalibratorList.hh
/// @author Oliver Lange

#ifndef INCLUDED_protocols_NoesyAssign_PeakCalibrator_HH
#define INCLUDED_protocols_NoesyAssign_PeakCalibrator_HH


// Unit Header
//#include <protocols/NoesyAssign/PeakCalibrator.fwd.hh>

// Package Headers
// #include <protocols/NoesyAssign/PeakCalibratorInfo.hh>
// #include <protocols/NoesyAssign/PeakAssignment.hh>
// #include <protocols/NoesyAssign/ResonanceList.fwd.hh>

// Project Headers
#include <core/types.hh>
#include <core/id/NamedAtomID.fwd.hh>
//#include <core/chemical/AA.hh>

// Utility headers
//#include <utility/exit.hh>
// #include <utility/excn/Exceptions.hh>
//#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>
// #include <numeric/numeric.functions.hh>
// #include <core/util/prof.hh>
//#include <core/util/Tracer.hh>
// #include <core/options/option.hh>
// #include <core/options/keys/abinitio.OptionKeys.gen.hh>
// #include <core/options/keys/run.OptionKeys.gen.hh>
//#include <core/options/keys/templates.OptionKeys.gen.hh>

//// C++ headers
//#include <cstdlib>
// #include <string>
// #include <list>
// #include <map>

namespace protocols {
namespace NoesyAssign {

class PeakCalibrator : public utility::pointer::ReferenceCount {
public:
  PeakCalibrator() : Q_backbone_( 1e11 ) { };
  PeakCalibrator( core::Real start ) : Q_backbone_( start ) { };
  core::Real operator() ( core::id::NamedAtomID const& atom ) const { return calibration_constant( atom ); }
  core::Real calibration_constant( core::id::NamedAtomID const& ) const { return Q_backbone_; };
  void interpolate( PeakCalibrator const& cal1, PeakCalibrator const& cal2 );

  core::Real Q_backbone_;
  core::Real Q_methyl_;
  core::Real Q_nonmethyl_sidechain_;
  core::Real Q_nonmethyl_beta_;

};

}
}

#endif
