// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @detailed
///
///
///
/// @author Oliver Lange

// Unit Headers
#include <protocols/NoesyAssign/Resonance.hh>


// Package Headers
#include <protocols/NoesyAssign/Exceptions.hh>
#include <core/id/NamedAtomID.hh>
// Project Headers
#include <core/chemical/AA.hh>

// Utility headers
#include <ObjexxFCL/format.hh>

// #include <utility/exit.hh>
// #include <utility/excn/Exceptions.hh>
// #include <utility/vector1.fwd.hh>
// #include <utility/pointer/ReferenceCount.hh>
// #include <numeric/numeric.functions.hh>
// #include <core/util/prof.hh>
#include <core/util/Tracer.hh>
// #include <core/options/option.hh>
// #include <core/options/keys/abinitio.OptionKeys.gen.hh>
// #include <core/options/keys/run.OptionKeys.gen.hh>
//#include <core/options/keys/templates.OptionKeys.gen.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <deque>


static core::util::Tracer tr("devel.NoesyAssign");

using core::Real;
using namespace core;
using namespace util;
//using namespace core::options;
//using namespace OptionKeys;

namespace protocols {
namespace NoesyAssign {

Resonance::Resonance() {}

Resonance::Resonance(  core::Size label, core::Real freq, core::Real error, core::id::NamedAtomID id) :
  label_ ( label ),
  freq_( freq ),
  error_( error ),
  atom_( id )
{}

Resonance::~Resonance() {}

void Resonance::write_to_stream( std::ostream& os ) const {
  os << ObjexxFCL::fmt::RJ( 10, label_ ) << " ";
  os << ObjexxFCL::fmt::F( 10, 3, freq_ ) << " " << ObjexxFCL::fmt::F( 10, 3, error_ ) << " ";
  os << ObjexxFCL::fmt::RJ( 5, atom_.atom() ) << " " << ObjexxFCL::fmt::RJ( 8, atom_.rsd() );
}

} //NoesyAssign
} //devel
