// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file CrossPeakList.hh
/// @author Oliver Lange

#ifndef INCLUDED_protocols_NoesyAssign_ResonanceList_HH
#define INCLUDED_protocols_NoesyAssign_ResonanceList_HH


// Unit Headers
#include <protocols/NoesyAssign/ResonanceList.fwd.hh>

// Package Headers
#include <protocols/NoesyAssign/Resonance.hh>

// Project Headers
#include <core/chemical/AA.hh>
#include <core/id/NamedAtomID.hh>
#include <core/types.hh>

// Utility headers
#include <utility/exit.hh>
// #include <utility/excn/Exceptions.hh>
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>
// #include <numeric/numeric.functions.hh>
// #include <core/util/prof.hh>
//#include <core/util/Tracer.hh>
// #include <core/options/option.hh>
// #include <core/options/keys/abinitio.OptionKeys.gen.hh>
// #include <core/options/keys/run.OptionKeys.gen.hh>
//#include <core/options/keys/templates.OptionKeys.gen.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <map>

namespace protocols {
namespace NoesyAssign {
class ResonanceList : public utility::pointer::ReferenceCount {

public:
	typedef utility::vector1< Resonance > Resonances;

private:
	typedef std::map< core::Size, Resonances > ResidueMap;
  typedef std::map< core::Size, Resonance > ResonanceIDs;

public:
  ResonanceList( std::string const& sequence );
  void read_from_stream( std::istream& );
  void write_to_stream( std::ostream& ) const;
  Resonance const& operator[] ( core::Size key ) { return map_[ key ]; };
  Resonance const& operator[] ( core::Size key ) const;
  typedef ResonanceIDs::const_iterator const_iterator;
  typedef ResonanceIDs::iterator iterator;
  const_iterator begin() const { return map_.begin(); };
  const_iterator end() const { return map_.end(); };
  Resonance const& operator[] ( core::id::NamedAtomID const& ) const;
	Resonances const& resonances_at_residue( core::Size resid ) const;
	bool has_residue( core::Size resi ) const;
  core::chemical::AA aa_from_resid( core::Size resi ) const;
	core::Size size() const { return map_.size(); };
	core::Size start_key() const { return map_.begin()->first; }
	core::Size last_key() const { return map_.rbegin()->first; }
	std::string const& sequence() const { return sequence_; }
protected:
	void update_residue_map();
private:
  ResonanceIDs map_;
	ResidueMap by_resid_;
  std::string sequence_;
};

}
}

#endif
