//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/ReportPSSMDifference.hh
/// @brief calculation of the difference in PSSM score between mutated and native pose
/// @author Hermann Zellner (hermann1.zellner@biologie.uni-regensburg.de)


#ifndef INCLUDED_protocols_ProteinInterfaceDesign_REPORTPSSMDIFFERENCE_HH_
#define INCLUDED_protocols_ProteinInterfaceDesign_REPORTPSSMDIFFERENCE_HH_

#include <core/types.hh>
#include <core/pose/Pose.hh>

#include <utility/vector1.hh>
#include <core/pack/task/PackerTask.hh>

#include <map>

namespace protocols {
namespace ProteinInterfaceDesign {


class ReportPSSMDifferences
{
public:
	typedef core::Size Size;
	typedef core::Real Real;
	typedef core::pose::Pose Pose;
public:
	ReportPSSMDifferences( ) {};

	ReportPSSMDifferences( ReportPSSMDifferences const & init ) { // copy constructor
		res_name1_ = init.res_name1_;
		pssm_data_ = init.pssm_data_;
	};
	core::Real calculate( Pose const & pose1, Pose const & pose2, core::pack::task::PackerTaskCOP const & task );

	std::map< Size, std::string > const & res_name1() const { return res_name1_; }

	utility::vector1< std::pair< core::chemical::AA, utility::vector1< Real > > > const & pssm_() const { return pssm_data_; }

	bool load_pssm_data(std::string const & native_filename);

	virtual ~ReportPSSMDifferences() {};
private:
	std::map< Size, std::string > res_name1_;
	utility::vector1< std::pair< core::chemical::AA, utility::vector1< Real > > > pssm_data_;
};

} //protocols
} //ProteinInterfaceDesign

#endif /* INCLUDED_protocols_ProteinInterfaceDesign_REPORTPSSMDIFFERENCE_HH_ */
