// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/ProteinInterfaceDesign/filters/RotamerBoltzmannWeightFilter.fwd.hh
/// @brief  forward declaration for RotamerBoltzmannWeightFilter
/// @author  Sarel Fleishman sarelf@uw.edu


#ifndef INCLUDED_protocols_ProteinInterfaceDesign_filters_RotamerBoltzmannWeightFilter_FWD_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_filters_RotamerBoltzmannWeightFilter_FWD_HH


// Utility headers
#include <utility/pointer/owning_ptr.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign{
namespace filters {

// Forward
class RotamerBoltzmannWeight;

// Types
typedef utility::pointer::owning_ptr< RotamerBoltzmannWeight >  RotamerBoltzmannWeightFilterOP;
typedef utility::pointer::owning_ptr< RotamerBoltzmannWeight const >  RotamerBoltzmannWeightFilterCOP;

} // namespace filters
} //namespace ProteinInterfaceDesign
} // namespace protocols

#endif
