// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/DockAndRetrieveSidechains.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_DockAndRetrieveSidechains_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_DockAndRetrieveSidechains_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/docking/DockingProtocol.hh>
#include <protocols/symmetric_docking/SymDockProtocol.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class DockAndRetrieveSidechains : public protocols::moves::Mover
{
public:
	DockAndRetrieveSidechains();
	protocols::moves::MoverOP clone() const;
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new DockAndRetrieveSidechains ); }
	void apply( core::pose::Pose & pose );
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~DockAndRetrieveSidechains();
	virtual std::string get_name() const;
private:
	protocols::docking::DockingProtocolOP docking_mover_;
	protocols::symmetric_docking::SymDockProtocolOP sym_docking_mover_;
	bool low_res_protocol_only_, conserve_foldtree_, symmetry_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_DockAndRetrieveSidechains_HH*/

