// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/RandomMutation.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_RandomMutation_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_RandomMutation_HH

#include <core/types.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <protocols/filters/Filter.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/ProteinInterfaceDesign/movers/DesignRepackMover.hh>
#include <protocols/moves/Mover.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class RandomMutation : public DesignRepackMover
{
public:
	RandomMutation();
	// for direct access
	void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;
	/// @brief this is the recursive function where the functionality takes place
	void GenerateMap( core::pose::Pose const & start_pose, core::pose::Pose & curr_pose, core::Size const jump_number );
	/// @brief minimizes rb and sc dofs for all of the hotspots
	void MinimizeHotspots( core::pose::Pose & pose );
	void parse_my_tag( utility::Tag::TagPtr const tag,
		protocols::moves::DataMap &,
		protocols::filters::Filters_map const &,
		protocols::moves::Movers_map const &,
		core::pose::Pose const & );
	protocols::moves::MoverOP clone() const { return( protocols::moves::MoverOP( new RandomMutation( *this ) ) ); }
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new RandomMutation ); }
	virtual ~RandomMutation();
private:
	core::scoring::ScoreFunctionOP scorefxn_;
	protocols::moves::MoverOP relax_mover_;
};


} //movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_TryRotamers_HH*/

