// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 sw=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/SubroutineMover.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu)

// Unit headers

#include <protocols/ProteinInterfaceDesign/movers/SubroutineMover.hh>
#include <protocols/ProteinInterfaceDesign/movers/SubroutineMoverCreator.hh>
#include <protocols/jd2/DockDesignParser.hh>
#include <protocols/jd2/JobDistributor.hh>
#include <protocols/jd2/Parser.fwd.hh>

// Project headers
#include <core/types.hh>
#include <core/pose/Pose.hh>
#include <utility/Tag/Tag.hh>

#include <protocols/moves/Mover.hh>
#include <core/util/Tracer.hh>

using namespace protocols::ProteinInterfaceDesign;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.SubroutineMover" );

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace protocols::moves;
using namespace core;

std::string
SubroutineMoverCreator::keyname() const
{
	return SubroutineMoverCreator::mover_name();
}

protocols::moves::MoverOP
SubroutineMoverCreator::create_mover() const {
	return new SubroutineMover;
}

std::string
SubroutineMoverCreator::mover_name()
{
	return "Subroutine";
}

protocols::moves::MoverOP
SubroutineMover::clone() const {
	return( protocols::moves::MoverOP( new SubroutineMover( *this ) ) );
}


void
SubroutineMover::apply( core::pose::Pose & pose )
{
	mover_->apply( pose );
}

void
SubroutineMover::parse_my_tag( TagPtr const tag,
		DataMap &,
		protocols::filters::Filters_map const &,
		Movers_map const &,
		core::pose::Pose const & pose )
{
	using namespace protocols::jd2;

	std::string const xml_fname( tag->getOption< std::string >( "xml_fname" ) );

	JobOP job( JobDistributor::get_instance()->current_job() );
	ParserOP ddparser = new DockDesignParser;
	TR<<"Parsing a subroutine xml_file"<<std::endl;
	TR<<"*************WARNING: AT THIS POINT, CONSTRAINTS ADDED TO THE POSE IN A SUBROUTINE WILL BE IGNORED***********"<<std::endl;
	core::pose::Pose nonconst_pose( pose );
	ddparser->generate_mover_from_pose( job, nonconst_pose, mover_, true /*new input*/, xml_fname );
}

protocols::moves::MoverOP
SubroutineMover::fresh_instance() const {
   return protocols::moves::MoverOP( new SubroutineMover );
}

SubroutineMover::~SubroutineMover(){}

SubroutineMover::SubroutineMover() :
	Mover( SubroutineMoverCreator::mover_name() ),
	mover_( NULL )
{}

std::string
SubroutineMover::get_name() const {
	return SubroutineMoverCreator::mover_name();
}

} //movers
} //ProteinInterfaceDesign
} //protocols

