// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/comparative_modeling/ConstraintRemodelMover.hh
/// @brief
/// @author Liz Kellogg ekellogg@u.washington.edu
/// @author James Thompson

// libRosetta headers

// Package headers
#include <protocols/moves/Mover.hh>

// Project headers
#include <core/pose/Pose.fwd.hh>

namespace protocols {
namespace comparative_modeling {

class ConstraintRemodelMover : public protocols::moves::Mover {

public:
	ConstraintRemodelMover()  {}
	~ConstraintRemodelMover() {}

	virtual void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;

}; // ConstraintRemodelMover

} // comparative_modeling
} // protocols
