// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/comparative_modeling/DynamicAlignmentStream.cc
/// @brief Alignment stream that generates a given number of alignments.
/// @author James Thompson

#include <core/sequence/Sequence.hh>
#include <core/sequence/SequenceAlignment.hh>
#include <core/sequence/ScoringScheme.hh>
#include <core/sequence/Aligner.hh>

#include <protocols/comparative_modeling/DynamicAlignmentStream.hh>


namespace protocols {
namespace comparative_modeling {

core::sequence::SequenceAlignment
DynamicAlignmentStream::get_alignment() {
	return aligner_->align( seq_x_, seq_y_, ss_ );
}


} // comparative_modeling
} // protocols
