// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/comparative_modeling/frag_refine.cc
/// @brief
/// @detailed

#include <core/pose/util.hh>
// AUTO-REMOVED #include <core/pose/Pose.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/fragment/FragSet.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#ifdef WIN32
#include <core/scoring/ScoreFunction.hh>
#endif

#include <protocols/abinitio/GunnCost.hh>
#include <protocols/abinitio/SmoothFragmentMover.hh>
#include <protocols/abinitio/SmoothFragmentMover.fwd.hh>
#include <protocols/abinitio/FragmentMover.hh>
#include <protocols/abinitio/FragmentMover.fwd.hh>

#include <protocols/moves/Mover.fwd.hh>
#include <protocols/moves/MonteCarlo.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>
#include <protocols/moves/TrialMover.hh>
#include <protocols/moves/TrialMover.fwd.hh>

#include <core/options/option.hh>
#include <core/options/keys/james.OptionKeys.gen.hh>

namespace protocols {
namespace comparative_modeling {

void fragment_refine(
	core::pose::Pose & pose,
	core::fragment::FragSetCOP fragset,
	core::scoring::ScoreFunctionOP scorefxn
) {
	using core::Real;
	using core::Size;

	// maybe make these function parameters eventually
	Real temperature( 10.0 );
	Size const n_loop  ( 3 );
	Real const end_bias( 30.0 );
	Size const n_trials( 12000 );
	core::kinematics::MoveMapOP movemap( new core::kinematics::MoveMap );
	movemap->set_bb( true );

	using namespace core::options;
	using namespace core::options::OptionKeys;
	if ( option[ james::real ]() ) {
		temperature = option[ james::real ]();
	}

	using namespace protocols::moves;
	using namespace protocols::abinitio;

	// object initialization
	MonteCarloOP mc( new MonteCarlo( pose, *scorefxn, temperature ) );
	ClassicFragmentMoverOP standard_mover(
		new ClassicFragmentMover( fragset, movemap )
	);
	SmoothFragmentMoverOP smooth_mover(
		new SmoothFragmentMover( fragset, movemap, new GunnCost )
	);
	standard_mover->set_end_bias( end_bias );
	smooth_mover  ->set_end_bias( end_bias );

	TrialMoverOP smooth_trials  ( new TrialMover( smooth_mover, mc   ) );
	TrialMoverOP standard_trials( new TrialMover( standard_mover, mc ) );
	// end object initialization

	Size n_accepts(0);

	for ( Size kk = 1; kk <= n_loop; ++kk ) {
		TrialMoverOP trials;
		if ( kk == 1 ) {
			trials = standard_trials;
		} else {
			trials = smooth_trials;
		}
		trials->keep_stats_type( accept_reject );

		// apply the TrialMover ~4000 times
		for ( Size ii = 1; ii <= n_trials; ++ii ) {
			trials->apply(pose);
			//mc->show_state();
		}
		//std::cout << std::endl;
		mc->recover_low( pose );
		n_accepts += trials->num_accepts();
		//std::cout << "n_accepts " << trials->num_accepts() << std::endl;
		//std::cout << "accept_rate " << trials->acceptance_rate() << std::endl;
	} // loop kk
	core::pose::setPoseExtraScores( pose, "fr_accepts", static_cast< Real > (n_accepts) );
} // fragment_refine

} // comparative_modeling
} // protocols
