// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file util
/// @brief protocols that are specific to docking low resolution
/// @detailed
/// @author Brian Weitzner


#ifndef INCLUDED_protocols_docking_util_HH
#define INCLUDED_protocols_docking_util_HH

#include <protocols/docking/types.hh>
#include <core/pose/Pose.fwd.hh>


namespace protocols {
namespace docking {
namespace util {

/// @brief Sets up a docking fold tree based on user-specified chains for the first and second partner
void setup_foldtree( core::pose::Pose & pose, std::string const partner_chainID, DockJumps movable_jumps );

} // metrics
} // docking
} // protocols

#endif
