// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   src/protocols/init.cc
/// @brief  Declare WidgetRegistrators as static (global) variables in this .cc file
///         so that at load time, they will be initialized, and the Creator classes
///         they register will be handed to the appropriate WidgetFactory.
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com)

#include <protocols/init.hh>
#include <core/init.hh>

#include <core/pack/task/operation/TaskOperationRegistrator.hh>
#include <protocols/moves/MoverFactory.hh>

#include <protocols/dna/RestrictDesignToProteinDNAInterfaceCreator.hh>
#include <protocols/dna/WatsonCrickRotamerCouplingsCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/FavorNativeResiduePreCycleCreator.hh>
#include <protocols/toolbox/TaskOperations/LimitAromaChi2OperationCreator.hh>
#include <protocols/toolbox/TaskOperations/LayerDesignOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/PreventChainFromRepackingOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/ProteinInterfaceDesignOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/RestrictByCalculatorsOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/RestrictChainToRepackingOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/RestrictToInterfaceOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/RestrictToNeighborhoodOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/DesignAroundOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/ThreadSequenceOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/RestrictNonSurfaceToRepackingOperationCreator.hh>
#include <protocols/toolbox/TaskOperations/RestrictToInterfaceVectorOperationCreator.hh>
#include <protocols/enzdes/DetectProteinLigandInterfaceOperationCreator.hh>
#include <protocols/enzdes/ProteinLigandInterfaceUpweighterOperationCreator.hh>

/// Mover creators
#include <protocols/enzdes/AddOrRemoveMatchCstsCreator.hh>
#include <protocols/enzdes/EnzRepackMinimizeCreator.hh>
#include <protocols/enzdes/EnzdesMoversCreator.hh>
#include <protocols/moves/ParsedProtocolCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PeptideStapleDesignMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/AddSidechainConstraintsToHotspotsCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PlaceSimultaneouslyMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/SetupHotspotConstraintsMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/HotspotDisjointedFoldTreeMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PlaceStubMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/LoopOverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/DesignMinimizeHbondsCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PlaceOnLoopCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/RandomMutationCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/ProteinInterfaceMultiStateDesignMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/LoopRemodelCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/SaveAndRetrieveSidechainsCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/TryRotamersCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/SubroutineMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/LoopFinderCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/HotspotHasherMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/DomainAssemblyCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/RepackMinimizeCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/InterfaceRecapitulationMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/DisulfideMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/DumpPdbCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/SetAtomTreeCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/MapHotspotCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/BestHotspotCstMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/BuildAlaPoseCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/DockAndRetrieveSidechainsCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PlacementAuctionMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PlacementMinimizationMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/VLBCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/BackrubDDMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/PrepackMoverCreator.hh>
#include <protocols/ProteinInterfaceDesign/movers/SpinMoverCreator.hh>
#include <protocols/flxbb/FlxbbDesignCreator.hh>
#include <protocols/fldsgn/BluePrintBDRCreator.hh>
#include <protocols/fldsgn/CircularPermutationCreator.hh>
#include <protocols/forge/remodel/RemodelLoopMoverCreator.hh>
#include <protocols/moves/IfMoverCreator.hh>
#include <protocols/moves/MutateResidueCreator.hh>
#include <protocols/moves/DsspMoverCreator.hh>
#include <protocols/moves/MatcherMoverCreator.hh>
#include <protocols/moves/MakePolyXMoverCreator.hh>
#include <protocols/moves/MinMoverCreator.hh>
#include <protocols/moves/MinPackMoverCreator.hh>
#include <protocols/moves/ScoreMoverCreator.hh>
#include <protocols/moves/ConstraintSetMoverCreator.hh>
#include <protocols/moves/PackRotamersMoverCreator.hh>
#include <protocols/moves/RotamerTrialsMoverCreator.hh>
#include <protocols/moves/ConformerSwitchMoverCreator.hh>
#include <protocols/moves/SwitchResidueTypeSetMoverCreator.hh>
#include <protocols/moves/GenericMonteCarloMoverCreator.hh>
#include <protocols/moves/SidechainMCMoverCreator.hh>
#include <protocols/moves/TaskAwareMinMoverCreator.hh>
#include <protocols/moves/ReportToDBCreator.hh>
#include <protocols/moves/RotamerRecoveryMoverCreator.hh>
#include <protocols/moves/MetropolisHastingsMoverCreator.hh>
#include <protocols/moves/BackboneMoverCreator.hh>
#include <protocols/moves/BackrubMoverCreator.hh>
#include <protocols/moves/SidechainMoverCreator.hh>
#include <protocols/moves/BackrubSidechainMoverCreator.hh>
#include <protocols/moves/RotamerTrialsMinMoverCreator.hh>
#include <protocols/relax/FastRelaxCreator.hh>
#include <protocols/dna/SeparateDnaFromNonDnaCreator.hh>
#include <protocols/dna/DnaInterfaceMinMoverCreator.hh>
#include <protocols/dna/DnaInterfacePackerCreator.hh>
#include <protocols/dna/DnaInterfaceMultiStateDesignCreator.hh>
#include <protocols/dna/DesignProteinBackboneAroundDNACreator.hh>
#include <protocols/motifs/MotifDnaPackerCreator.hh>
#include <protocols/ligand_docking/LigandDesignCreator.hh>
#include <protocols/ligand_docking/GrowLigandCreator.hh>
#include <protocols/ligand_docking/AddHydrogensCreator.hh>
#include <protocols/ligand_docking/TranslateCreator.hh>
#include <protocols/ligand_docking/TransformCreator.hh>
#include <protocols/ligand_docking/CompoundTranslateCreator.hh>
#include <protocols/ligand_docking/RotateCreator.hh>
#include <protocols/ligand_docking/StartFromCreator.hh>
#include <protocols/ligand_docking/RandomConformersCreator.hh>
#include <protocols/ligand_docking/MinimizeLigandCreator.hh>
#include <protocols/ligand_docking/SlideTogetherCreator.hh>
#include <protocols/ligand_docking/TetherLigandCreator.hh>
#include <protocols/ligand_docking/MinimizeBackboneCreator.hh>
#include <protocols/ligand_docking/HighResDockerCreator.hh>
#include <protocols/ligand_docking/FinalMinimizerCreator.hh>
#include <protocols/ligand_docking/InterfaceScoreCalculatorCreator.hh>

// Filter creators
#include <protocols/filters/FilterFactory.hh>

#include <protocols/enzdes/EnzFilterCreators.hh>
#include <protocols/ProteinInterfaceDesign/dock_design_filter_creators.hh>
#include <protocols/ProteinInterfaceDesign/filters/InterfaceHolesFilterCreator.hh>
#include <protocols/ProteinInterfaceDesign/filters/DesignableResiduesFilterCreator.hh>
#include <protocols/ProteinInterfaceDesign/filters/RmsdFilterCreator.hh>
#include <protocols/ProteinInterfaceDesign/filters/RotamerBoltzmannWeightFilterCreator.hh>
#include <protocols/ProteinInterfaceDesign/filters/DisulfideFilterCreator.hh>
#include <protocols/ProteinInterfaceDesign/filters/StubScoreFilterCreator.hh>
#include <protocols/ProteinInterfaceDesign/filters/SequenceRecoveryFilterCreator.hh>
#include <protocols/filters/HeavyAtomFilterCreator.hh>
#include <protocols/filters/HolesFilterCreator.hh>
#include <protocols/filters/PackStatFilterCreator.hh>
#include <protocols/filters/BasicFilterCreators.hh>
#include <protocols/filters/ContingentFilterCreator.hh>
#include <protocols/filters/CompleteConnectionsFilterCreator.hh>
#include <protocols/filters/RGFilterCreator.hh>
#include <protocols/filters/ScoreCutoffFilterCreator.hh>
#include <protocols/filters/AtomicContactFilterCreator.hh>
#include <protocols/fldsgn/filters/CoreDunbrackFilterCreator.hh>
#include <protocols/fldsgn/filters/FragQualFilterCreator.hh>
#include <protocols/fldsgn/filters/HelixPairingFilterCreator.hh>
#include <protocols/fldsgn/filters/NcontactsFilterCreator.hh>
#include <protocols/fldsgn/filters/SecondaryStructureFilterCreator.hh>
#include <protocols/fldsgn/filters/SheetTopologyFilterCreator.hh>

// DataLoader creators
#include <protocols/jd2/parser/DataLoaderFactory.hh>
#include <protocols/jd2/parser/StandardLoaderCreators.hh>
#include <protocols/ligand_docking/LigandDockingLoaderCreators.hh>

#include <core/scoring/methods/EnergyMethodRegisterer.hh>
#include <protocols/scoring/methods/ResidualDipolarCouplingEnergyRigidSegmentsCreator.hh>
#include <protocols/scoring/methods/SpecialRotamerEnergyCreator.hh>



namespace protocols {

static core::scoring::methods::EnergyMethodRegistrator< scoring::methods::ResidualDipolarCouplingEnergyRigidSegmentsCreator > ResidualDipolarCouplingEnergyRigidSegmentsCreator_registrator;
static core::scoring::methods::EnergyMethodRegistrator< scoring::methods::SpecialRotamerEnergyCreator > SpecialRotamerEnergyCreator_registrator;

using namespace core::pack::task::operation;

static TaskOperationRegistrator< protocols::dna::RestrictDesignToProteinDNAInterfaceCreator > RestrictDesignToProteinDNAInterfaceCreator_registrator;
static TaskOperationRegistrator< protocols::dna::WatsonCrickRotamerCouplingsCreator > WatsonCrickRotamerCouplingsCreator_registrator;

static TaskOperationRegistrator< protocols::toolbox::TaskOperations::LimitAromaChi2OperationCreator > LimitAromaChi2OperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::LayerDesignOperationCreator > LayerDesignOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::PreventChainFromRepackingOperationCreator > PreventChainFromRepackingOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::ProteinInterfaceDesignOperationCreator > ProteinInterfaceDesignOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::RestrictByCalculatorsOperationCreator > RestrictByCalculatorsOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::RestrictChainToRepackingOperationCreator > RestrictChainToRepackingOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::RestrictToInterfaceOperationCreator > RestrictToInterfaceOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::RestrictToInterfaceVectorOperationCreator > RestrictToInterfaceVectorOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::RestrictToNeighborhoodOperationCreator > RestrictToNeighborhoodOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::DesignAroundOperationCreator > DesignAroundOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::ThreadSequenceOperationCreator > ThreadSequenceOperationCreator_registrator;
static TaskOperationRegistrator< protocols::toolbox::TaskOperations::RestrictNonSurfaceToRepackingOperationCreator > RestrictNonSurfaceToRepackingOperationCreator_registrator;

static TaskOperationRegistrator< protocols::enzdes::DetectProteinLigandInterfaceOperationCreator > DetectProteinLigandInterfaceOperationCreator_registrator;
static TaskOperationRegistrator< protocols::enzdes::ProteinLigandInterfaceUpweighterOperationCreator > ProteinLigandInterfaceUpweighterOperationCreator_registrator;

using namespace moves;

static MoverRegistrator< enzdes::AddOrRemoveMatchCstsCreator > reg_AddOrRemoveMatchCstsCreator;
static MoverRegistrator< enzdes::EnzRepackMinimizeCreator > reg_EnzRepackMinimizeCreator;
static MoverRegistrator< enzdes::PredesignPerturbMoverCreator > reg_PredesignPerturbMoverCreator;
static MoverRegistrator< protocols::moves::ParsedProtocolCreator > reg_ParsedProtocolCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PeptideStapleDesignMoverCreator > reg_PeptideStapleDesignMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::AddSidechainConstraintsToHotspotsCreator > reg_AddSidechainConstraintsToHotspotsCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PlaceSimultaneouslyMoverCreator > reg_PlaceSimultaneouslyMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::SetupHotspotConstraintsMoverCreator > reg_SetupHotspotConstraintsMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PlaceStubMoverCreator > reg_PlaceStubMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::LoopOverCreator > reg_LoopOverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::SubroutineMoverCreator > reg_SubroutineCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::DesignMinimizeHbondsCreator > reg_DesignMinimizeHbondsCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PlaceOnLoopCreator > reg_PlaceOnLoopCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::ProteinInterfaceMultiStateDesignMoverCreator > reg_ProteinInterfaceMultiStateDesignMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::LoopRemodelCreator > reg_LoopRemodelCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::SaveAndRetrieveSidechainsCreator > reg_SaveAndRetrieveSidechainsCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::TryRotamersCreator > reg_TryRotamersCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::LoopFinderCreator > reg_LoopFinderCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::HotspotHasherMoverCreator > reg_HotspotHasherMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::DomainAssemblyCreator > reg_DomainAssemblyCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::RepackMinimizeCreator > reg_RepackMinimizeCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::InterfaceRecapitulationMoverCreator > reg_InterfaceRecapitulationMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::DisulfideMoverCreator > reg_DisulfideMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::DumpPdbCreator > reg_DumpPdbCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::SetAtomTreeCreator > reg_SetAtomTreeCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::MapHotspotCreator > reg_MapHotspotCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::BestHotspotCstMoverCreator > reg_BestHotspotCstMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::BuildAlaPoseCreator > reg_BuildAlaPoseCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::FavorNativeResiduePreCycleCreator > reg_FavorNativeResiduePreCycleCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::DockAndRetrieveSidechainsCreator > reg_DockAndRetrieveSidechainsCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PlacementAuctionMoverCreator > reg_PlacementAuctionMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PlacementMinimizationMoverCreator > reg_PlacementMinimizationMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::RandomMutationCreator > reg_RandomMutationCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::VLBCreator > reg_VLBCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::BackrubDDMoverCreator > reg_BackrubDDMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::PrepackMoverCreator > reg_PrepackMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::SpinMoverCreator > reg_SpinMoverCreator;
static MoverRegistrator< ProteinInterfaceDesign::movers::HotspotDisjointedFoldTreeMoverCreator > reg_HotsotDisjointedFoldTreeMoverCreator;
static MoverRegistrator< flxbb::FlxbbDesignCreator > reg_FlxbbDesignCreator;
static MoverRegistrator< fldsgn::BluePrintBDRCreator > reg_BluePrintBDRCreator;
static MoverRegistrator< fldsgn::CircularPermutationCreator > reg_CircularPermutationCreator;
static MoverRegistrator< forge::remodel::RemodelLoopMoverCreator > reg_RemodelLoopMoverCreator;
static MoverRegistrator< moves::IfMoverCreator > reg_IfMoverCreator;
static MoverRegistrator< moves::MutateResidueCreator > reg_MutateResidueCreator;
static MoverRegistrator< moves::DsspMoverCreator > reg_DsspMoverCreator;
static MoverRegistrator< moves::MakePolyXMoverCreator > reg_MakePolyXMoverCreator;
static MoverRegistrator< moves::MatcherMoverCreator > reg_MatcherMoverCreator;
static MoverRegistrator< moves::MinMoverCreator > reg_MinMoverCreator;
static MoverRegistrator< moves::MinPackMoverCreator > reg_MinPackMoverCreator;
static MoverRegistrator< moves::ScoreMoverCreator > reg_ScoreMoverCreator;
static MoverRegistrator< moves::ConstraintSetMoverCreator > reg_ConstraintSetMoverCreator;
static MoverRegistrator< moves::PackRotamersMoverCreator > reg_PackRotamersMoverCreator;
static MoverRegistrator< moves::ConformerSwitchMoverCreator > reg_ConformerSwitchMoverCreator;
static MoverRegistrator< moves::SwitchResidueTypeSetMoverCreator > reg_SwitchResidueTypeSetMoverCreator;
static MoverRegistrator< moves::GenericMonteCarloMoverCreator > reg_GenericMonteCarloMoverCreator;
static MoverRegistrator< moves::SidechainMCMoverCreator > reg_SidechainMCMoverCreator;
static MoverRegistrator< moves::TaskAwareMinMoverCreator > reg_TaskAwareMinMoverCreator;
static MoverRegistrator< moves::ReportToDBCreator > reg_ReportToDBCreator;
static MoverRegistrator< moves::RotamerRecoveryMoverCreator > reg_RotamerRecoveryMoverCreator;
static MoverRegistrator< moves::MetropolisHastingsMoverCreator > reg_MetropolisHastingsMoverCreator;
static MoverRegistrator< moves::SmallMoverCreator > reg_SmallMoverCreator;
static MoverRegistrator< moves::ShearMoverCreator > reg_ShearMoverCreator;
static MoverRegistrator< moves::BackrubMoverCreator > reg_BackrubMoverCreator;
static MoverRegistrator< moves::SidechainMoverCreator > reg_SidechainMoverCreator;
static MoverRegistrator< moves::BackrubSidechainMoverCreator > reg_BackrubSidechainMoverCreator;
static MoverRegistrator< moves::RotamerTrialsMoverCreator > reg_RotamerTrialsMoverCreator;
static MoverRegistrator< moves::RotamerTrialsMinMoverCreator > reg_RotamerTrialsMinMoverCreator;
static MoverRegistrator< relax::FastRelaxCreator> reg_FastRelaxCreator;
static MoverRegistrator< dna::SeparateDnaFromNonDnaCreator > reg_SeparateDnaFromNonDnaCreator;
static MoverRegistrator< dna::DnaInterfaceMinMoverCreator > reg_DnaInterfaceMinMoverCreator;
static MoverRegistrator< dna::DnaInterfacePackerCreator > reg_DnaInterfacePackerCreator;
static MoverRegistrator< dna::DnaInterfaceMultiStateDesignCreator > reg_DnaInterfaceMultiStateDesignCreator;
static MoverRegistrator< dna::DesignProteinBackboneAroundDNACreator > reg_DesignProteinBackboneAroundDNACreator;
static MoverRegistrator< motifs::MotifDnaPackerCreator > reg_MotifDnaPackerCreator;
static MoverRegistrator< ligand_docking::LigandDesignCreator > reg_LigandDesignCreator;
static MoverRegistrator< ligand_docking::GrowLigandCreator > reg_GrowLigandCreator;
static MoverRegistrator< ligand_docking::AddHydrogensCreator > reg_AddHydrogensCreator;
static MoverRegistrator< ligand_docking::TranslateCreator > reg_TranslateCreator;
static MoverRegistrator< ligand_docking::TransformCreator > reg_TransformCreator;
static MoverRegistrator< ligand_docking::CompoundTranslateCreator > reg_CompoundTranslateCreator;
static MoverRegistrator< ligand_docking::RotateCreator > reg_RotateCreator;
static MoverRegistrator< ligand_docking::StartFromCreator > reg_StartFromCreator;
static MoverRegistrator< ligand_docking::RandomConformersCreator > reg_RandomConformersCreator;
static MoverRegistrator< ligand_docking::MinimizeLigandCreator > reg_MinimizeLigandCreator;
static MoverRegistrator< ligand_docking::SlideTogetherCreator > reg_SlideTogetherCreator;
static MoverRegistrator< ligand_docking::TetherLigandCreator > reg_TetherLigandCreator;
static MoverRegistrator< ligand_docking::MinimizeBackboneCreator > reg_MinimizeBackboneCreator;
static MoverRegistrator< ligand_docking::HighResDockerCreator > reg_HighResDockerCreator;
static MoverRegistrator< ligand_docking::FinalMinimizerCreator > reg_FinalMinimizerCreator;
static MoverRegistrator< ligand_docking::InterfaceScoreCalculatorCreator > reg_InterfaceScoreCalculatorCreator;

using namespace filters;

static FilterRegistrator< protocols::enzdes::DiffAtomSasaFilterCreator > reg_DiffAtomSasaFilterCreator;
static FilterRegistrator< protocols::enzdes::EnzScoreFilterCreator > reg_EnzScoreFilterCreator;
static FilterRegistrator< protocols::enzdes::LigBurialFilterCreator > reg_LigBurialFilterCreator;
static FilterRegistrator< protocols::enzdes::LigDSasaFilterCreator > reg_LigDSasaFilterCreator;
static FilterRegistrator< protocols::enzdes::LigInterfaceEnergyFilterCreator > reg_LigInterfaceEnergyFilterCreator;
static FilterRegistrator< protocols::enzdes::RepackWithoutLigandFilterCreator > reg_RepackWithoutLigandFilterCreator;
static FilterRegistrator< protocols::filters::AtomicContactFilterCreator > reg_AtomicContactFilterCreator;
static FilterRegistrator< protocols::filters::CompleteConnectionsFilterCreator > reg_CompleteConnectionsFilterCreator;
static FilterRegistrator< protocols::filters::CompoundFilterCreator > reg_CompoundFilterCreator;
static FilterRegistrator< protocols::filters::ContingentFilterCreator > reg_ContingentFilterCreator;
static FilterRegistrator< protocols::filters::FalseFilterCreator > reg_FalseFilterCreator;
static FilterRegistrator< protocols::filters::HeavyAtomFilterCreator > reg_HeavyAtomFilterCreator;
static FilterRegistrator< protocols::filters::HolesFilterCreator > reg_HolesFilterCreator;
static FilterRegistrator< protocols::filters::PackStatFilterCreator > reg_PackStatFilterCreator;
static FilterRegistrator< protocols::filters::StochasticFilterCreator > reg_StochasticFilterCreator;
static FilterRegistrator< protocols::filters::ScoreCutoffFilterCreator > reg_ScoreCutoffFilterCreator;
static FilterRegistrator< protocols::fldsgn::filters::CoreDunbrackFilterCreator > reg_CoreDunbrackFilterCreator;
static FilterRegistrator< protocols::fldsgn::filters::FragQualFilterCreator > reg_FragQualFilterCreator;
static FilterRegistrator< protocols::fldsgn::filters::HelixPairingFilterCreator > reg_HelixPairingFilterCreator;
static FilterRegistrator< protocols::fldsgn::filters::NcontactsFilterCreator > reg_NcontactsFilterCreator;
static FilterRegistrator< protocols::fldsgn::filters::SecondaryStructureFilterCreator > reg_SecondaryStructureFilterCreator;
static FilterRegistrator< protocols::fldsgn::filters::SheetTopologyFilterCreator > reg_SheetTopologyFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::AlaScanFilterCreator > reg_AlaScanFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::BuriedUnsatHbondFilterCreator > reg_BuriedUnsatHbondFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::DdgFilterCreator > reg_DdgFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::EnergyPerResidueFilterCreator > reg_EnergyPerResidueFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::DesignableResiduesFilterCreator > reg_DesignableResiduesFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::DisulfideFilterCreator > reg_DisulfideFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::InterfaceHolesFilterCreator > reg_InterfaceHolesFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::RmsdFilterCreator > reg_RmsdFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::RotamerBoltzmannWeightFilterCreator > reg_RotamerBoltzmannWeightFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::SequenceRecoveryFilterCreator > reg_SequenceRecoveryFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::filters::StubScoreFilterCreator > reg_StubScoreFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::HbondsToResidueFilterCreator > reg_HbondsToResidueFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::InterfaceSasaFilterCreator > reg_InterfaceSasaFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::NeighborTypeFilterCreator > reg_NeighborTypeFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::ResidueBurialFilterCreator > reg_ResidueBurialFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::ResidueDistanceFilterCreator > reg_ResidueDistanceFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::ResiduesInInterfaceFilterCreator > reg_ResiduesInInterfaceFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::ScoreTypeFilterCreator > reg_ScoreTypeFilterCreator;
static FilterRegistrator< protocols::ProteinInterfaceDesign::TerminusDistanceFilterCreator > reg_TerminusDistanceFilterCreator;

using namespace jd2::parser;
static DataLoaderRegistrator< ScoreFunctionLoaderCreator > reg_ScoreFunctionLoaderCreator;
static DataLoaderRegistrator< TaskOperationLoaderCreator > reg_TaskOperationLoaderCreator;
static DataLoaderRegistrator< ScoringGridLoaderCreator > reg_ScoringGridLoaderCreator;
static DataLoaderRegistrator< FragSetLoaderCreator > reg_FragSetLoaderCreator;
static DataLoaderRegistrator< ligand_docking::InterfaceBuilderLoaderCreator > reg_InterfaceBuilderLoaderCreator;
static DataLoaderRegistrator< ligand_docking::MoveMapBuilderLoaderCreator > reg_MoveMapBuilderLoaderCreator;

void init( int argc, char * argv [] )
{
	core::init( argc, argv );
}

void init( utility::vector1< std::string > const & args )
{
	core::init( args );
}

}

