// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_MoveMapBuilder_HH
#define INCLUDED_protocols_ligand_docking_MoveMapBuilder_HH

// Unit Headers
#include <protocols/ligand_docking/MoveMapBuilder.fwd.hh>
#include <protocols/ligand_docking/ligand_options/Interface.hh>
#include <protocols/ligand_docking/InterfaceBuilder.fwd.hh>

// Package Headers
#include <core/kinematics/MoveMap.fwd.hh>

//// Project Headers
#include <protocols/moves/Mover.hh>

//// Scripter Headers
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/moves/DataMap.hh>

// Utility Headers
#include <utility/pointer/ReferenceCount.hh>

//Auto Headers
#include <protocols/loops/Loop.fwd.hh>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {

///@brief
class MoveMapBuilder: public utility::pointer::ReferenceCount
{
public:
	MoveMapBuilder();
	virtual ~MoveMapBuilder();
	MoveMapBuilder(MoveMapBuilder const & that);

	void parse_my_tag(
		utility::Tag::TagPtr const tag,
		protocols::moves::DataMap & datamap
	);

	core::kinematics::MoveMapOP
	build(core::pose::Pose const &) const;

	InterfaceBuilderOP
	get_sc_interface_builder()const;

private:
	utility::vector1<std::string> chains_; // ligand around which to minimize
	InterfaceBuilderOP sc_interface_builder_; // which side chains to minimize?
	InterfaceBuilderOP bb_interface_builder_; // which backbone residues to minimize?

	bool minimize_water_;

	void
	set_all_chi(
			core::pose::Pose const & pose,
			core::kinematics::MoveMapOP movemap
	)const;

	void
	set_all_bb(
			core::pose::Pose const & pose,
			core::kinematics::MoveMapOP movemap
	)const;

	void
	remove_ligands_to_not_minimize(
		core::pose::Pose const & pose,
		ligand_options::Interface & interface
	) const;


};

} //namespace ligand_docking
} //namespace protocols

#endif
