// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/match/output/UpstreamDownstreamCollisionFilter.hh
/// @brief  Declaration for class to filter matches where the upstream residues collide with the downstream partner
/// @author Alex Zanghellini (zanghell@u.washington.edu)
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com), porting to mini

#ifndef INCLUDED_protocols_match_output_UpstreamDownstreamCollisionFilter_HH
#define INCLUDED_protocols_match_output_UpstreamDownstreamCollisionFilter_HH

// Unit headers
#include <protocols/match/output/UpstreamDownstreamCollisionFilter.fwd.hh>

// Package headers
#include <protocols/match/BumpGrid.fwd.hh>
#include <protocols/match/output/MatchFilter.hh>
#include <protocols/match/output/UpstreamHitCacher.fwd.hh>
#include <protocols/match/downstream/DownstreamBuilder.fwd.hh>

// Project headers
#include	<core/pose/Pose.fwd.hh>
// AUTO-REMOVED #include <core/id/AtomID.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/scoring/methods/ShortRangeTwoBodyEnergy.fwd.hh>


// Utility headers
// AUTO-REMOVED #include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>

//Auto Headers
#include <core/id/AtomID.fwd.hh>
#include <utility/vector1_bool.hh>


namespace protocols {
namespace match {
namespace output {

/// @brief This class is used to detect collisions between upstream residues
/// and downstream poses.
class UpstreamDownstreamCollisionFilter : public MatchFilter {
public:
	typedef core::Real Real;

public:
	UpstreamDownstreamCollisionFilter(
		std::string filter_name,
		UpstreamHitCacherOP coordinate_cacher );

	virtual
	~UpstreamDownstreamCollisionFilter();

	void
	set_downstream_pose( core::pose::Pose const & downstream_pose );

	void
	set_num_geometric_constraints( Size n_geomcst );

	/// @brief Do not perform any collision detection between an upstream residue and the downstream
	/// pose if there is a chemical bond between them
	void
	set_chemical_bond_from_upstream_to_downstream( Size geomcst_id );

	void
	set_downstream_builder( Size geomcst_id, downstream::DownstreamBuilderCOP builder );

	/// @brief Returns true if there is at least one placement of the
	/// downstream partner which does not exceed the collision tolerance
	/// with any of the upstream residues.
	virtual
	bool
	passes_filter(
		match const & m
	) const;

	/// @brief Returns true if the specified downstream position does not
	/// collide more than tolerated with any of the upstream residues
	virtual
	bool
	passes_filter(
		match_dspos1 const & m
	) const;

	void set_filter_by_lj( bool setting );
	void set_lj_cutoff( Real setting );
	void set_lj_atr_weight( Real setting );
	void set_lj_rep_weight( Real setting );
	void set_lj_sol_weight( Real setting );

	void set_tolerated_overlap( Real setting );

private:
	bool passes_etable_filter( match_dspos1 const & m ) const;
	bool passes_hardsphere_filter( match_dspos1 const & m ) const;

private:
	bool filter_by_lj_;
	Real wfa_atr_;
	Real wfa_rep_;
	Real wfa_sol_;
	Real lj_cutoff_;
	Real tolerated_overlap_;
	Real max_overlap_dis_;

	core::pose::PoseOP empty_pose_;
	core::scoring::ScoreFunctionOP empty_sfxn_;

	UpstreamHitCacherOP cacher_;
	core::scoring::methods::ShortRangeTwoBodyEnergyOP   etable_energy_;
	BumpGridOP bump_grid_;

	utility::vector1< downstream::DownstreamBuilderCOP > dsbuilders_;

	utility::vector1< bool > us_ds_chemical_bond_; // skip residues that form a chemical bond to the downstream partner

	/// NOT THREADSAFE!
	mutable core::pose::PoseOP downstream_pose_;
	mutable utility::vector1< core::Vector > coords_;
	utility::vector1< core::id::AtomID > downstream_atoms_;
	utility::vector1< utility::vector1< Size > > per_res_atom_ind_;
};


}
}
}

#endif
