// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/IfMover.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu)

// Unit headers
#include <protocols/moves/IfMover.hh>
#include <protocols/moves/IfMoverCreator.hh>

#include <utility/Tag/Tag.hh>
#include <core/util/Tracer.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/filters/Filter.hh>
#include <protocols/moves/DataMap.fwd.hh>

namespace protocols {
namespace moves {

static core::util::Tracer TR( "protocols.moves.IfMover" );

std::string
IfMoverCreator::keyname() const
{
	return IfMoverCreator::mover_name();
}

protocols::moves::MoverOP
IfMoverCreator::create_mover() const {
	return new IfMover;
}

std::string
IfMoverCreator::mover_name()
{
	return "If";
}

void
IfMover::apply( core::pose::Pose & pose )
{
	if( filter_->apply( pose ) ){
		mover_->apply( pose );
		moves::MoverStatus const status( mover_->get_last_move_status() );
		protocols::moves::Mover::set_last_move_status( status );
	}
}

std::string
IfMover::get_name() const {
	return IfMoverCreator::mover_name();
}

void
IfMover::parse_my_tag( utility::Tag::TagPtr const tag,
											protocols::moves::DataMap &,
											protocols::filters::Filters_map const &filters,
											protocols::moves::Movers_map const &movers,
											core::pose::Pose const & )
{
	using namespace protocols::filters;

	TR<<"If mover\n";
	std::string const mover_name( tag->getOption< std::string >( "mover_name" ));
	std::string const filter_name( tag->getOption< std::string >( "filter_name" ) );

	Movers_map::const_iterator find_mover( movers.find( mover_name ) );
	Filters_map::const_iterator find_filter( filters.find( filter_name ));
	if( find_mover == movers.end() ) {
		TR<<"WARNING WARNING!!! mover not found in map. skipping:\n"<<tag<<std::endl;
		runtime_assert( find_mover != movers.end() );
	}
	if( find_filter == filters.end() ) {
		TR<<"WARNING WARNING!!! filter not found in map. skipping:\n"<<tag<<std::endl;
		runtime_assert( find_filter == filters.end() );
	}
	mover_ = find_mover->second; // no cloning to allow other movers to change this mover at their parse time
	filter_ = find_filter->second; //no cloning to allow other movers to change this filter during their apply
	TR << "with mover \"" << mover_name << "\" and filter \"" << filter_name <<std::endl;
}


} //moves
} //protocols

