// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file OutputMovers.hh
/// @brief File to contain classes that deal with output and pdb dumping
/// @detailed
/// @author Monica Berrondo


#ifndef INCLUDED_protocols_moves_OutputMovers_HH
#define INCLUDED_protocols_moves_OutputMovers_HH

// Unit headers

#include <protocols/moves/OutputMovers.fwd.hh>

#include <core/pose/Pose.fwd.hh>

#include <protocols/moves/Mover.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>

#include <core/io/pdb/pose_io.hh>

#include <core/util/Tracer.hh>
// AUTO-REMOVED #include <core/util/prof.hh>

// ObjexxFCL Headers
// AUTO-REMOVED #include <ObjexxFCL/format.hh>
// AUTO-REMOVED #include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <map>
#include <string>

// Utility Headers

namespace protocols {
namespace moves {

using core::util::T;
using core::util::Error;
using core::util::Warning;

// a mover to dump pdbs within cycles using movers (see DockingHighRes and DockingLowRes for examples on usage
class PDBDumpMover : public Mover
{
public:
	//constructor
	PDBDumpMover(std::string name_in, core::util::Tracer const & tr=core::io::pdb::TR_dump_pdb_dummy);

	//destructor
	~PDBDumpMover();

	virtual void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;

	void name( std::string name_in );

	void clear();

private:
	std::string name_;
	int num_;

	core::util::Tracer tracer_;

}; // class PDBDumpMover

// allows something profiler output to be printed to the screen during a move cycle
class ProfilerMover : public Mover
{
public:

	//constructor
	ProfilerMover();

	//destructor
	~ProfilerMover();

	virtual void apply( core::pose::Pose & /* pose*/ );
	virtual std::string get_name() const;
};

// allows mc.show_scores to be used inside a cycle of movers
class MCShowMover : public Mover
{
public:

	//constructors
	MCShowMover( MonteCarloOP mc_in );

	//destructor
	~MCShowMover();

	virtual void apply( core::pose::Pose & pose );
	virtual std::string get_name() const;

private:
	// the monte carlo that needs to be shown
	MonteCarloOP mc_;
};
} // moves
} // protocols

#endif //INCLUDED_protocols_moves_OutputMovers_HH
