// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/moves/ReportToDB.fwd.hh
/// @brief  report data to sqlite database
/// @author Matthew O'Meara

#ifndef INCLUDED_protocols_moves_ReportToDB_HH
#define INCLUDED_protocols_moves_ReportToDB_HH

#include <protocols/moves/Mover.hh>
#include <protocols/moves/ReportToDB.fwd.hh>

#include <core/pose/Pose.hh>

#include <utility/Tag/Tag.fwd.hh>
#include <utility/exit.hh>

#include <string>

#ifndef DB_SQLITE3

namespace protocols{
namespace moves{

class ReportToDB : public protocols::moves::Mover {
public:
	ReportToDB():
		Mover("ReportToDB")
	{}
	ReportToDB(std::string const & name):
		Mover(name)
	{}

	virtual ~ReportToDB(){}
	virtual MoverOP fresh_instance() const { return new ReportToDB; }
	virtual MoverOP clone() const { return new ReportToDB( *this ); }
	virtual	std::string	get_name() const { return "ReportToDB"; }

	virtual
	void
	parse_my_tag(
		TagPtr const,
		DataMap &,
		Filters_map const &,
		Movers_map const &,
		Pose const &)
	{}

	virtual
	void
	apply(Pose&) {
		utility_exit_with_message("Sqlite database support not found: Please recompile with './scons.py extras=sqlite'");
	}
};

} // moves namespace
} // protocols namespace

//////////////////////////////////////////
#else // DB_SQLITE3
//////////////////////////////////////////

#include <core/id/AtomID_Map.fwd.hh>
#include <core/scoring/geometric_solvation/ExactOccludedHbondSolEnergy.hh>
#include <core/scoring/EnergyMap.hh>
#include <core/scoring/hbonds/HBondSet.hh>
#include <core/types.hh>


// utility headers
#include <utility/vector1.hh>
#include <utility/sql_database/sqlite3_interface.hh>

#include <sqlite3.h>

// c++ headers
#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <sstream>





// namespaces
using namespace std;
using namespace boost;
using namespace core;
	using namespace conformation;
	using namespace kinematics;
	using namespace chemical;
	using namespace id;
	using namespace pose;
	using namespace scoring;
		using namespace hbonds;
		using namespace geometric_solvation;
//using utility::file::FileName;
using utility::vector1;


namespace protocols{
namespace moves{


class ReportToDB : public protocols::moves::Mover {

public:
	ReportToDB();

	ReportToDB(string const & name);

	ReportToDB(
		string const & name,
		string const & database_fname,
		string const & schema_fname,
		string const & sample_source,
		ScoreFunctionOP scfxn );

	ReportToDB(ReportToDB const & src);

	virtual ~ReportToDB();

	virtual MoverOP fresh_instance() const;

	virtual MoverOP clone() const;

	virtual std::string get_name() const { return "ReportToDB"; }

	virtual
	void
	parse_my_tag(
		TagPtr const tag,
		protocols::moves::DataMap & /*data*/,
		Filters_map const & /*filters*/,
		protocols::moves::Movers_map const & /*movers*/,
		Pose const & /*pose*/ );
	string
	pose_name(Pose& pose);

	void
	initialize_database();

	void
	close_db();

	void
	prepare_sql(string const & sql_stmt);

	void
	create_tables();

	Size
	insert_protocol_row();

	Size
	insert_structure_row(
		Pose const & pose,
		bool const & isNative,
		string const & resolution,
		string const & refinementProgram);

	void
	insert_structure_score_rows(
		Pose & pose,
		ScoreFunctionCOP scfxn,
		Size const struct_id);

	void
	insert_residue_scores_rows(
		Pose & pose,
		ScoreFunctionOP scfxn,
		Size const struct_id);

	void
	insert_residues_pdb_rows(
		Pose const & pose,
		Size const struct_id);

	Size
	insert_site_row(
		Pose const & pose,
		Size const & struct_id,
		Size const & resNum,
		Size const & atmNum,
		bool const & is_donor);

	void
	insert_site_pdb_row(
		Pose const & pose,
		Size const & resNum,
		Size const & atmNum,
		Size const & site_id);

	void
	insert_site_environment_row(
		Pose const & pose,
		Size const & resNum,
		Size const & atmNum,
		Size const & site_id,
		//id::AtomID_Map< Real > const & atom_sasa,
		id::AtomID_Map< vector1<HBondCOP> > const & site_partners,
		id::AtomID_Map< Real > const & site_hbond_energies);

	void
	insert_site_atoms_row(
		Pose const & pose,
		Size const & resNum,
		Size const & atmNum,
		Size const & site_id);


	Size
	insert_hbond_row(
		HBond const & hbond,
		Size const & struct_id,
		AtomID_Map< Size > const & site_ids,
		AtomID_Map< vector1<HBondCOP> > const & site_partners);

	void
	insert_hbond_geom_coords(
		Pose const & pose,
		HBond const & hbond,
		Size const & hbond_id);


	void
	insert_hbond_lennard_jones_row(
		core::pose::Pose const & pose,
		core::scoring::hbonds::HBond const & hbond,
		core::Size const & hbond_id);



	void
	report_hbonds(
		Pose& pose,
		Size const struct_id);

	virtual
	void
	apply(
		Pose& pose);

private:
	string database_fname;
	string schema_fname;
	string sample_source;
	ScoreFunctionOP scfxn;
	ExactOccludedHbondSolEnergy geo_sol_energy;
	EnergyMap emap_temp_;
	static Size protocol_id; /* initialized to 0 by default */
	bool initialized;
	utility::sql_database::Sqlite3Interface db_interface;
};

}//moves
}//protocols

#endif // #DB_SQLITE3

#endif //INCLUDED_protocols_moves_BackboneMover_FWD_HH
