// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/moves/SidechainMCMover.hh
/// @brief definition of SidechainMCMover class and functions
/// @author Colin A. Smith (colin.smith@ucsf.edu)


#ifndef INCLUDED_protocols_moves_SidechainMCMover_HH
#define INCLUDED_protocols_moves_SidechainMCMover_HH

// Unit Headers
#include <protocols/moves/SidechainMover.hh>
#include <protocols/moves/SidechainMCMover.fwd.hh>
#include <protocols/moves/MetropolisHastingsMover.fwd.hh>
#include <protocols/fast_sc_mover/SimpleInteractionGraph.hh>
#include <protocols/fast_sc_mover/SimpleInteractionGraph.fwd.hh>
// Protocols Headers
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>


// Core Headers
// AUTO-REMOVED #include <core/pack/task/TaskFactory.hh>
#include <core/chemical/ResidueType.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <numeric/random/random.hh>

#include <core/scoring/dunbrack/RotamerLibrary.fwd.hh>
#include <core/scoring/dunbrack/RotamerLibraryScratchSpace.fwd.hh>

// Utility Headers
#include <utility/Tag/Tag.fwd.hh>

// AUTO-REMOVED #include <utility/vector0.hh>
// AUTO-REMOVED #include <utility/vector1.hh>
// AUTO-REMOVED #include <numeric/conversions.hh>

//Auto Headers
#include <core/pack/task/TaskFactory.fwd.hh>
#include <utility/vector1_bool.hh>

#include <core/scoring/ScoreFunction.hh>

namespace protocols {
namespace moves {


/// @brief class for non-discrete side chain sampling using Dunbrack rotamer probabilities/distributions
class SidechainMCMover : public SidechainMover {

public:
//
	/// @brief default constructor
	SidechainMCMover();

	/// @brief constructor with user provided rotamer library
	SidechainMCMover(
		core::scoring::dunbrack::RotamerLibrary const & rotamer_library
	);

	~SidechainMCMover();

	void
	show_counters( std::ostream & out );

	void
	setup( core::scoring::ScoreFunctionCOP sfxn );

	//parser stuff
	protocols::moves::MoverOP clone() const;
	protocols::moves::MoverOP fresh_instance() const;
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );

	/// @brief apply a sidechain move to a Pose object
	void
	apply(
		core::pose::Pose & pose
	);

	virtual std::string get_name() const;

	void
	set_ntrials( core::Size ntrial ){
		ntrials_ = ntrial;
	};

	core::Size
	ntrials(){
		return 	ntrials_;
	}

	void
	set_temperature( core::Real temp ){
		temperature_ = temp;
	}

	core::Real
	temperature(){
		return temperature_;
	}

	void
	set_scorefunction( core::scoring::ScoreFunction const & sfxn ){
		sfxn_ = sfxn;
	}

	core::scoring::ScoreFunction &
	scorefunction(){
		return sfxn_;
	}

	virtual
	bool
	is_multi_trial()
	{
		return true;
	}

	virtual
	protocols::moves::MetropolisHastingsMoverAP
	metropolis_hastings_mover()
	{
		return metropolis_hastings_mover_;
	}

	virtual
	void
	set_metropolis_hastings_mover(
		protocols::moves::MetropolisHastingsMoverAP metropolis_hastings_mover
	)
	{
		metropolis_hastings_mover_ = metropolis_hastings_mover;
	}


private:

	bool pass_metropolis( core::Real delta_energy , core::Real last_proposal_density_ratio );

	void
	perturb_chi(numeric::random::RandomGenerator Rand,
							core::Real max_deviation,
							utility::vector1<core::Real> & current_chi,
							utility::vector1<core::Real> & new_chi
	);

	//ek for fast sidechain sampling and internal mc trials
	utility::vector1< core::conformation::ResidueOP > current_;
	utility::vector1< core::conformation::ResidueOP > previous_;
	utility::vector1< core::conformation::ResidueOP > best_;
	core::Real temperature_;
	core::Size ntrials_;
	core::Real best_energy_;
	core::Real current_energy_;
	core::scoring::ScoreFunction sfxn_;
	protocols::fast_sc_mover::SimpleInteractionGraphOP ig_;
	core::Real accepts_;
	core::Real current_ntrial_;
	protocols::moves::MetropolisHastingsMoverAP metropolis_hastings_mover_;

}; //SidechainMCMover


} // moves
} // protocols

#endif

