// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet;
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/moves/TrajectoryRecorder.cc
///
/// @brief
/// @author


// Unit header or inline function header
#include <protocols/moves/TrajectoryRecorder.hh>

// Other project headers or inline function headers
#include <core/pose/Pose.hh>
#include <core/scoring/Energies.hh>
#include <protocols/moves/MonteCarlo.hh>

// External library headers

// C++ headers
#include <iomanip>

// Operating system headers

// Forward declarations


namespace protocols {
namespace moves {

TrajectoryRecorder::TrajectoryRecorder() :
	stride_(1),
	model_count_(0),
	step_count_(0)
{}

TrajectoryRecorder::~TrajectoryRecorder()
{}

TrajectoryRecorder::TrajectoryRecorder( TrajectoryRecorder const & /* other */ )
{
	// copy constructor not allowed
	runtime_assert(false);
}

TrajectoryRecorder&
TrajectoryRecorder::operator=( TrajectoryRecorder const & /* other */ )
{
	// assignment not allowed
	runtime_assert(false);
	return * this;
}

void
TrajectoryRecorder::write_model(
	core::pose::Pose const & pose
)
{
	trajectory_stream_ << "MODEL     " << std::setw(4) << model_count_ << std::endl;
	trajectory_stream_ << "REMARK  99 " << step_count_ << std::endl;
	trajectory_stream_ << "REMARK  98 " << pose.energies().total_energy() << std::endl;
	pose.dump_pdb(trajectory_stream_);
	trajectory_stream_ << "ENDMDL" << std::endl;
}

void
TrajectoryRecorder::reset(
	protocols::moves::MonteCarlo const & mc
)
{
	model_count_ = 0;
	step_count_ = 0;
	write_model(mc.last_accepted_pose());
}

void
TrajectoryRecorder::update_after_boltzmann(
	protocols::moves::MonteCarlo const & mc
)
{
	++step_count_;

	if (step_count_ % stride_ == 0) {
		++model_count_;
		write_model(mc.last_accepted_pose());
	}
}


} // namespace moves
} // namespace protocols
