// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file
/// @brief
/// @author Ingemar Andre


#ifndef INCLUDED_protocols_moves_symmetry_SymMinMover_HH
#define INCLUDED_protocols_moves_symmetry_SymMinMover_HH

// Unit headers
#include <protocols/moves/symmetry/SymMinMover.fwd.hh>
#include <protocols/moves/MinMover.hh>

// Package headers
//#include <protocols/moves/Mover.hh>

//#include <core/kinematics/MoveMap.fwd.hh>
//#include <core/optimization/MinimizerOptions.fwd.hh>
//#include <core/pose/Pose.fwd.hh>
//#include <core/scoring/ScoreFunction.fwd.hh>
//#include <core/types.hh>

// ObjexxFCL Headers

// C++ Headers

// Utility Headers

namespace protocols {
namespace moves {
namespace symmetry {
///////////////////////////////////////////////////////////////////////////////
class SymMinMover : public protocols::moves::MinMover
{
public:

	// default constructor
	SymMinMover();

	SymMinMover( std::string const & );

	~SymMinMover();

	// constructor with arguments
	SymMinMover(
		core::kinematics::MoveMapOP movemap_in,
		ScoreFunctionCOP scorefxn_in,
		std::string const & min_type_in,
		Real tolerance_in,
		bool use_nb_list_in,
		bool deriv_check_in = false,
		bool deriv_check_verbose_in = false
	);

	void apply( core::pose::Pose & pose_ );
	virtual std::string get_name() const;

private:
	core::kinematics::MoveMapOP symmetric_movemap_;

};

} // symmetry
} // moves
} // rosetta
#endif
