/*                                                                            */
/*                           ----  SPARTA   ----                              */
/*     Shifts Prediction from Analogue of Residue type and Torsion Angle      */
/*                           Yang Shen and Ad Bax                             */
/*                    J. Biomol. NMR, 38, 289-302 (2007)                      */
/*                 NIH, NIDDK, Laboratory of Chemical Physics                 */
/*                     version, 1.2 (build 2009.0928.17)                     */
/*                                                                            */
/*                      for any problem, please contact                       */
/*                          shenyang@niddk.nih.gov                            */
/*                                                                            */
/******************************************************************************/

#ifndef SPARTA_H
#define SPARTA_H





#include <protocols/sparta/GDB.hh>
#include <protocols/sparta/PDB.hh>
#include <protocols/sparta/ANN.hh>

#include <core/pose/Pose.fwd.hh>

#include <core/types.hh>

#include <algorithm>

namespace protocols {
namespace sparta {

typedef std::vector<std::string> StringList;
typedef std::map<float, std::map<float, float> >  PHIPSI_ERR_SURF;


class Sparta
{
  ///mini specific additions...
private:
  static bool options_registered_;

public:
  static void register_options();

  core::Real score_pose( core::pose::Pose const& );

private:
  ////SPARTA originals
  std::string SPARTA_DIR, PRED_DIR, TAB_DIR, SHIFT_DIR, PDB_DIR, EXCLUDED;

  std::string slash_char;

  char buf[300], lbuf[1000];

  std::string inName; // input PDB coordinates file name
  std::string inNames; // name list of multiple input PDB coordinates files
  PDB inPDB;
  GDB inTab; //inTab, input talble file from PDB coordinates file
  GDB REF_CS_Tab;

  std::string sumName; // output summary name
  std::string sourceName; // output summary name

  float** U_ANGLES;
  float** U_RING_SHIFTS;
  std::string** U_NAME ;
  float *U_HN_HB, *U_HA_HB, *U_CO_HB;// *HB_SHIFT_HN;

  std::string tripFileName;
  GDB TRIPLET_Tab; //triplet table file

  std::string weightFileName; // file name for wieght talble of score function
  GDB WEIGHT_Tab; // talble for weights of score function

  std::string homoFileName; // file name for sequence homology talble
  GDB HOMO_Tab; // homology talble

  std::string rcFileName; //file name for random coil chemical shift talble
  GDB RC_Tab; // random coil chemical shift talble

  std::string adjFileName; //file name for the adjustment of random coil chemical shift talble
  GDB ADJ_Tab; // "Random Coil Adjustment Table"

  std::string prevFileName; // file name for the table of "Random Coil Adjustments for Previous Residue Type"
  GDB PREV_Tab; // talble for "Random Coil Adjustments for Previous Residue Type"

  std::string nextFileName; // file name for the table of "Random Coil Adjustments for Next Residue Type"
  GDB NEXT_Tab; // talble for "Random Coil Adjustments for Next Residue Type"

  std::string fitFileName; // file name for the table of "fitting parameters"
  GDB FIT_Tab; // talble for "fitting parameters"

  std::string refCSFileName;

  int firstRes, lastRes; // First/last RESID to use for prediction

  int r1,rN; // first and last RESID in seqList

  float tVal; // Max similarity score threshold, not used in the program

  std::map<int, std::string> residList; // one-letter amino acid residue list from input PDB coordinates file
  std::string sequence; // one-letter amino acid residue list from input PDB coordinates file in the format of one std::string

  std::map<int, std::string> aN, aN_ALL; // Backbone atom list used by program "N HA C CA CB H"

  int matchCount; //Max Match Count per query triplet

  std::string pdbListName; //table file name for names of candidate proteins

  std::map<std::string, std::map<std::string, float> > Fitting;

  std::string AAlist; // amino acid list (with a sequence allowed by ANN)
  std::map<std::string,  std::vector<float> > BLOSUM_62;	// BLOSUM 62 matrix
  std::map<int,  std::vector<float> > ANN_IN_MTX;	// input matrix for neural netwrok calculation
  std::map< std::string, std::map<int, std:: vector<float> > > ANN_CS_OUTPUT_FULL; // input matrix from neural netwrok calculation, indexed by atom name, resID and prediction
  std::map<int, float> CHI2_ANGLES, OMEGA_ANGLES;

  std::map<int, std::map< std::string,float> > SURFACE_EXPOSURE; //indexed by resID, atomName

  std::map<int, std::string>::iterator itN;
  std::map<int, std::map< std::string, std::string> >::iterator it;

  std::map< std::string, ANN> SPARTA_ANN;
  std::map< std::string, std::map< std::string, PHIPSI_ERR_SURF> > SPARTA_ERR_SURF; //indexed by AA, atomName, phi, psi

  bool bCreateOutput_;
public:
   std::vector< std::string> argList; // list for all vilid arguments

  Sparta( std::string const& chem_shifts );
  //  Sparta(const std::string& fileName);

  void printSyntax();

  void init();
  void runPredict();

  core::Real compareRef(GDB &Pred_Sum);

  void getResInfo(); //Get the list of useful shifts from a given residue. get 2nd chemical shift and apply correction

  void runANN_Prediction(); // Initiate an ANN prediction for a single protein
  core::Real run_A_ANN_Prediction(); // Run ANN prediction for a single protein
  void runANN_Predictions(); // Initiate and run ANN prediction for multiple proteins
  void runANN_Prediction(const std::string& pName); // Initiate an ANN prediction for a single protein using its file name

  float getANN_PredError(float phi, float psi, std::string aa, std::string aName); // get the prediction error from error surface
  void init_PredErrorSurface();

  // get random coil chemical shift for atom 'aName' of residue 'resName'
  float getRC(const std::string& resName, const std::string& aName);
  float getRCadj(const std::string& resName, const std::string& aName);
  float getPrevRCadj(const std::string& prev_rName, const std::string& aName);
  float getNextRCadj(const std::string& next_rName, const std::string& aName);
  float getWeight(const std::string& Name, const std::string& aName);

  //preset the args form command line
  void setup_defaults();

  void mkdir_pred(const std::string& d);// create a directory for prediction results
  int MKDIR(const char *dirName);
  bool isDirExists(const std::string &Dir) ;


  float getDiff( float ang1, float ang2); // calculate the different between two angles
  float getAVG( std::vector<float> &v1);
  float getSTD( std::vector<float> &v1);
  float getRMS( std::vector<float> &v1, std::vector<float> &v2);

  char * ftoa( float n, char *buff, char f='g', int prec=6 );
  char * itoa( int n, char *buff, int base=10 );
};

}
}

#endif
