// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file ./src/protocols/toolbox/PoseMetricCalculator/NcontactsCalculator.hh
/// @brief header file for NcontactsCalculator class.
/// @detailed
/// @author Nobuyasu Koga ( nobuyasu@uw.edu )


#ifndef INCLUDED_protocols_toolbox_PoseMetricCalculators_NcontactsCalculator_HH
#define INCLUDED_protocols_toolbox_PoseMetricCalculators_NcontactsCalculator_HH

#include <core/pose/metrics/PoseMetricCalculatorBase.hh>
#include <core/util/MetricValue.fwd.hh>
#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/conformation/Atom.fwd.hh>
#include <core/conformation/Residue.fwd.hh>
#include <protocols/fldsgn/topology/SS_Info2.fwd.hh>

// Utility headers
// AUTO-REMOVED #include <utility/vector1.hh>

//// C++ headers
// AUTO-REMOVED #include <string>

namespace protocols {
namespace toolbox {
namespace PoseMetricCalculators {

class NcontactsCalculator : public core::pose::metrics::StructureDependentCalculator {
public:


	typedef core::pose::metrics::StructureDependentCalculator Super;
	typedef std::string String;
	typedef core::Size Size;
	typedef core::Real Real;
	typedef core::pose::Pose Pose;
	typedef core::conformation::Atom Atom;
	typedef core::conformation::Residue Residue;
	typedef core::pose::metrics::PoseMetricCalculatorOP PoseMetricCalculatorOP;
  typedef core::util::MetricValueBase MetricValueBase;
	typedef protocols::fldsgn::topology::SS_Info2 SS_Info2;


public:// constructor/destructor


	/// @brief default constructor
	NcontactsCalculator();

	/// @brief default constructor
	NcontactsCalculator( Real const condist, Size const isep_sep );

	/// @brief copy constructor
	NcontactsCalculator( NcontactsCalculator const & rval );

	/// @brief destructor
	virtual ~NcontactsCalculator();


public:// virtual constructor


	/// @brief make clone
  PoseMetricCalculatorOP clone() const { return new NcontactsCalculator( *this ); }


protected:


  virtual void lookup( String const & key, MetricValueBase * valptr ) const;
  virtual std::string print( String const & key ) const;
  virtual void recompute( Pose const & this_pose );


private:

	/// @brief distact used for juding contact pair
	Real condist_;

	/// @brief residue pairs of i < i+isep_residue_ are used for counting #countacts
	Size isep_residue_;

	/// @brief  #atom-contacts among all heavy atoms
	Real nc_allatm_;

  /// @brief  #atom-contacts among hydrophobic heavy atoms
	Real nc_hpatm_;

	/// @brief #atom-contacts among heavy atoms of sidechains of hydrophobic residues
	Real nc_hpres_;

	/// @brief
	Real ss_entrpy_;

}; //NontactCalculator


} // ns PoseMetricCalculators
} // ns toolbox
} // ns protocols

#endif
