// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file TopologyBroker
/// @brief  top-class (Organizer) of the TopologyBroker mechanism
/// @detailed responsibilities:
///           maintains list of ToplogyClaimers
///           maintains DofClaims -- exclusive or non-exclusively markedup dofs like BackboneClaim, IntraResClaim, JumpClaim
///           generates FoldTree, MoveMap, and collects samplers provided by TopologyClaimers
/// @author Oliver Lange


#ifndef INCLUDED_protocols_topology_broker_util_HH
#define INCLUDED_protocols_topology_broker_util_HH


// Unit Headers

// Package Headers
#include <protocols/topology_broker/TopologyBroker.fwd.hh>

// Project Headers

// ObjexxFCL Headers

// Utility headers
//#include <utility/io/izstream.hh>
//#include <utility/io/ozstream.hh>

//#include <core/util/Tracer.hh>
//#include <core/options/option.hh>

//#include <core/options/option_macros.hh>

//// C++ headers
#include <istream>

// AUTO-REMOVED #include <string>


// option key includes


namespace protocols {
namespace topology_broker {

//not public anymore
//extern void add_claims_from_file( TopologyBroker&, std::string const& file, bool const do_I_need_frags = true );
//extern void add_claims_from_stream( TopologyBroker&, std::istream&, bool const do_I_need_frags);

///read broker::setup flag and add all claims to Broker
extern void add_cmdline_claims( TopologyBroker&, bool do_I_need_frags = true );

}
}

#endif
