// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/wum/WorkUnitBase.cc
/// @brief
/// @author Mike Tyka

#include <protocols/wum/WorkUnit_BatchRelax.hh>
#include <protocols/wum/WorkUnitBase.hh>
#include <protocols/wum/SilentStructStore.hh>

#include <core/io/silent/SilentFileData.hh>
#include <core/io/silent/SilentStructFactory.hh>
#include <core/io/silent/SilentStruct.hh>
#include <core/io/silent/ProteinSilentStruct.hh>
#include <core/options/option.hh>
#include <core/options/keys/relax.OptionKeys.gen.hh>
#include <core/pose/Pose.hh>
#include <core/pose/util.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/util/Tracer.hh>
#include <protocols/relax/FastRelax.hh>


#if defined(WIN32) || defined(__CYGWIN__)
	#include <ctime>
#endif

namespace protocols {
namespace wum {


static core::util::Tracer TR("WorkUnit_BatchRelax");


///  WorkUnit_BatchRelax

void
WorkUnit_BatchRelax::run(){
  using namespace core::options;
  using namespace core::options::OptionKeys;

	// scorefxn and sequence file are controllable from commandline - unfortunately that means
  // there can only be one setting. The batch solution handles this better but is also much more
  // restricted in a way.
	core::scoring::ScoreFunctionOP scorefxn;
	scorefxn = core::scoring::getScoreFunction();
  protocols::relax::FastRelax relax( scorefxn,  option[ OptionKeys::relax::sequence_file ]() );
	if( native_pose_ ){
		relax.set_native_pose( native_pose_ );
	}
  // relax handles all the silent structures in situ
  relax.batch_apply( decoys().store() );

	TR << "NRELAXED: " << decoys().size() << std::endl;
}


void
WorkUnit_BatchRelax::set_native_pose( core::pose::PoseCOP native_pose){
	native_pose_ = native_pose;
}




}
}

