// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/loophash/WorkUnit_LoopHash.hh
/// @brief
/// @author Mike Tyka


#include <protocols/wum/WorkUnitBase.hh>


#ifndef INCLUDED_protocols_wum_WorkUnit_LoopHash_HH
#define INCLUDED_protocols_wum_WorkUnit_LoopHash_HH


namespace protocols {
namespace wum {



class WorkUnit_BatchRelax;
typedef utility::pointer::owning_ptr< WorkUnit_BatchRelax > WorkUnit_BatchRelaxOP;
typedef utility::pointer::owning_ptr< WorkUnit_BatchRelax const > WorkUnit_BatchRelaxCOP;

class WorkUnit_BatchRelax : public protocols::wum::WorkUnit_SilentStructStore {
	public:
      WorkUnit_BatchRelax():
        WorkUnit_SilentStructStore()
      {

      }

    // @brief Run the workunit - overloaded by children of this class
    virtual void run();

		virtual protocols::wum::WorkUnitBaseOP clone() const {
			return new WorkUnit_BatchRelax( *this );
		}

		void
		set_native_pose( core::pose::PoseCOP native_pose);

  protected:
  private:

		core::pose::PoseCOP native_pose_;
};





}
}

#endif

