# (c) Copyright Rosetta Commons Member Institutions.
# (c) This file is part of the Rosetta software suite and is made available under license.
# (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
# (c) For more information, see http://www.rosettacommons.org. Questions about this can be
# (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.



class Controller:
    def __init__( self ):
        self.modified_objects = []
        self.new_objects      = []
        self.deleted_objects  = []
        self.global_update = False #

    def object_modified( self, obj_name ):
        if obj_name not in self.modified_objects:
            self.modified_objects = self.modified_objects + [ obj_name ]

    def object_new( self, obj_name ):
        if obj_name not in self.new_objects:
            self.new_objects = self.new_objects + [ obj_name ]

    def object_deleted( self, obj_name ):
        if obj_name not in self.deleted_objects:
            self.deleted_objects = self.deleted_objects + [ obj_name ]

    def do_global_update( self ):
        self.global_update = True

    def handle_object_modified( self, obj_name ):
        if obj_name in self.modified_objects:
            self.modified_objects.remove( obj_name )
            return True
        else:
            return False

    def handle_new_objects( self ):
        new_objects = self.new_objects[ : ]
        self.new_objects = []

        return new_objects

    def handle_object_deleted( self, obj_name ):
        if obj_name in self.deleted_objects:
            self.deleted_objects.remove( obj_name )
            return True
        else:
            return False

    def handle_global_update( self ):
        ret = self.global_update
        self.global_update = False
        return ret
